/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.references.ExtensionReferenceBase;
import org.jetbrains.idea.devkit.util.PsiUtil;

class ExperimentalFeatureIdContributor
extends PsiReferenceContributor {
    ExperimentalFeatureIdContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"isFeatureEnabled", "setFeatureEnabled"}))).definedInClass(Experiments.class.getName())), (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((expression, host) -> new PsiReference[]{new ExperimentalFeatureIdReference((PsiElement)host)}), (double)0.0);
    }

    private static final class ExperimentalFeatureIdReference
    extends ExtensionReferenceBase {
        private ExperimentalFeatureIdReference(PsiElement element) {
            super(element);
        }

        @Override
        protected String getExtensionPointFqn() {
            return "com.intellij.experimentalFeature";
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return DevKitBundle.message("code.convert.experimental.feature.id.cannot.resolve", this.getValue());
        }

        public Object @NotNull [] getVariants() {
            List<LookupElement> variants = Collections.synchronizedList(new SmartList());
            this.processCandidates((Processor<? super Extension>)((Processor)extension -> {
                GenericAttributeValue<String> id = extension.getId();
                if (id == null || extension.getXmlElement() == null) {
                    return true;
                }
                String value = id.getStringValue();
                if (value == null) {
                    return true;
                }
                boolean requireRestart = "true".equals(ExperimentalFeatureIdReference.getAttributeValue(extension, "requireRestart"));
                boolean isInternalFeature = "true".equals(ExperimentalFeatureIdReference.getAttributeValue(extension, "internalFeature"));
                String description2 = " " + StringUtil.notNullize((String)ExperimentalFeatureIdReference.getDescription(extension), (String)DevKitBundle.message("code.convert.experimental.feature.no.description", new Object[0]));
                String percentage = ExperimentalFeatureIdReference.getAttributeValue(extension, "percentOfUsers");
                variants.add((LookupElement)LookupElementBuilder.create((Object)extension.getXmlElement(), (String)value).withIcon(requireRestart ? AllIcons.Nodes.PluginRestart : AllIcons.Nodes.Plugin).withBoldness(isInternalFeature).withTailText(description2, true).withTypeText((String)(percentage != null ? percentage + "%" : "")));
                return true;
            }));
            return variants.toArray(LookupElement.EMPTY_ARRAY);
        }

        @Nullable
        private static String getDescription(Extension extension) {
            DomFixedChildDescription description2 = extension.getGenericInfo().getFixedChildDescription("description");
            if (description2 == null) {
                return null;
            }
            DomElement element = (DomElement)ContainerUtil.getFirstItem((List)description2.getValues((DomElement)extension));
            return element instanceof GenericDomValue ? ((GenericDomValue)element).getStringValue() : null;
        }
    }
}

