/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.navigation.structure.PluginDescriptorTreeElement;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PluginDescriptorXmlStructureViewModel
extends XmlStructureViewTreeModel
implements StructureViewModel.ElementInfoProvider {
    public PluginDescriptorXmlStructureViewModel(@NotNull XmlFile file, @Nullable Editor editor) {
        super(file, editor);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        XmlTag rootTag;
        XmlFile file = this.getPsiFile();
        if (DescriptorUtil.isPluginXml((PsiFile)file) && (rootTag = file.getRootTag()) != null) {
            return new PluginDescriptorTreeElement(rootTag, true, true);
        }
        return super.getRoot();
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }

    public Sorter @NotNull [] getSorters() {
        return new Sorter[]{new Sorter(){

            public Comparator getComparator() {
                return (o1, o2) -> {
                    if (o1 instanceof PluginDescriptorTreeElement && o2 instanceof PluginDescriptorTreeElement) {
                        PluginDescriptorTreeElement e1 = (PluginDescriptorTreeElement)((Object)((Object)o1));
                        PluginDescriptorTreeElement e2 = (PluginDescriptorTreeElement)((Object)((Object)o2));
                        if (e1.isTopLevelNode() && e2.isTopLevelNode()) {
                            return 0;
                        }
                    }
                    return ALPHA_SORTER.getComparator().compare(o1, o2);
                };
            }

            public boolean isVisible() {
                return ALPHA_SORTER.isVisible();
            }

            @NotNull
            public ActionPresentation getPresentation() {
                return new ActionPresentationData(DevKitBundle.message("structure.sort.alphabetically.in.groups", new Object[0]), DevKitBundle.message("structure.sort.alphabetically.in.groups.description", new Object[0]), AllIcons.ObjectBrowser.Sorted);
            }

            @NotNull
            public String getName() {
                return "PluginDescriptorStructureAlphaSorter";
            }
        }};
    }

    @NotNull
    protected @NotNull Class @NotNull [] getSuitableClasses() {
        return new Class[]{XmlTag.class};
    }
}

