/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.navigation.structure.PluginDescriptorStructureUtil;

public class PluginDescriptorTreeElement
extends PsiTreeElementBase<XmlTag>
implements DumbAware {
    private final boolean myIsRoot;
    private final boolean myIsTopLevelNode;

    public PluginDescriptorTreeElement(@NotNull XmlTag psiElement, boolean isRootTag, boolean isTopLevelNode) {
        super((PsiElement)psiElement);
        this.myIsRoot = isRootTag;
        this.myIsTopLevelNode = isTopLevelNode;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        XmlTag tag = (XmlTag)this.getElement();
        if (tag == null || !tag.isValid()) {
            return Collections.emptyList();
        }
        return ContainerUtil.map2List((Object[])tag.getSubTags(), psiElement -> new PluginDescriptorTreeElement((XmlTag)psiElement, false, this.myIsRoot));
    }

    @Nullable
    public String getPresentableText() {
        XmlTag element = (XmlTag)this.getElement();
        try {
            return PluginDescriptorStructureUtil.getTagDisplayText(element);
        }
        catch (IndexNotReadyException ignore) {
            return PluginDescriptorStructureUtil.safeGetTagDisplayText(element);
        }
    }

    public String getLocationString() {
        try {
            return PluginDescriptorStructureUtil.getTagLocationString((XmlTag)this.getElement());
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    public Icon getIcon(boolean open) {
        try {
            return PluginDescriptorStructureUtil.getTagIcon((XmlTag)this.getElement());
        }
        catch (IndexNotReadyException ignore) {
            return PluginDescriptorStructureUtil.DEFAULT_ICON;
        }
    }

    public boolean isSearchInLocationString() {
        return true;
    }

    public boolean isTopLevelNode() {
        return this.myIsTopLevelNode;
    }
}

