/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.navigation.LineMarkerInfoHelper;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

public class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UElement uElement = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (!(uElement instanceof UField)) {
            return;
        }
        ExtensionPointDeclarationRelatedItemLineMarkerProvider.process((UField)uElement, element.getProject(), result);
    }

    private static void process(UField uField, Project project, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(uField)) {
            return;
        }
        String epFqn = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpFqn(uField);
        if (epFqn == null) {
            return;
        }
        ExtensionPoint point = ExtensionPointIndex.findExtensionPoint(project, PluginRelatedLocatorsUtils.getCandidatesScope(project), epFqn);
        if (point == null) {
            return;
        }
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)uField.getUastAnchor());
        if (identifier == null) {
            return;
        }
        ExtensionPointCandidate candidate = new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.createPointer((PsiElement)point.getXmlTag()), epFqn);
        RelatedItemLineMarkerInfo<PsiElement> info = LineMarkerInfoHelper.createExtensionPointLineMarkerInfo(Collections.singletonList(candidate), identifier);
        result.add(info);
    }

    @Nullable
    private static String resolveEpFqn(UField uField) {
        UExpression initializer = uField.getUastInitializer();
        UExpression epNameExpression = null;
        if (initializer instanceof UCallExpression) {
            epNameExpression = ((UCallExpression)initializer).getArgumentForParameter(0);
        } else if (initializer instanceof UQualifiedReferenceExpression) {
            UExpression selector = ((UQualifiedReferenceExpression)initializer).getSelector();
            if (!(selector instanceof UCallExpression)) {
                return null;
            }
            epNameExpression = ((UCallExpression)selector).getArgumentForParameter(0);
        }
        if (epNameExpression == null) {
            return null;
        }
        return UastUtils.evaluateString((UExpression)epNameExpression);
    }

    private static boolean isExtensionPointNameDeclarationField(UField uField) {
        if (!uField.isFinal()) {
            return false;
        }
        UExpression initializer = uField.getUastInitializer();
        if (!(initializer instanceof UCallExpression) && !(initializer instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)uField.getType());
        if (fieldClass == null) {
            return false;
        }
        String qualifiedClassName = fieldClass.getQualifiedName();
        return ExtensionPointName.class.getName().equals(qualifiedClassName) || ProjectExtensionPointName.class.getName().equals(qualifiedClassName) || InheritanceUtil.isInheritor((PsiClass)fieldClass, (boolean)false, (String)KeyedExtensionCollector.class.getName());
    }
}

