/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.DevKitIcons;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedClassLineMarkerProviderBase;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class DescriptionTypeRelatedItemLineMarkerProvider
extends DevkitRelatedClassLineMarkerProviderBase {
    private static final NotNullFunction<PsiFile, Collection<? extends PsiElement>> CONVERTER = psiFile -> ContainerUtil.createMaybeSingletonList((Object)psiFile);
    private static final NotNullFunction<PsiFile, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = psiFile -> GotoRelatedItem.createItems(Collections.singleton(psiFile), (String)"DevKit");
    private final GutterIconDescriptor.Option myDescriptionOption = new GutterIconDescriptor.Option("devkit.description", DevKitBundle.message("gutter.related.option.description", new Object[0]), DevKitIcons.Gutter.DescriptionFile);
    private final GutterIconDescriptor.Option myBeforeAfterOption = new GutterIconDescriptor.Option("devkit.beforeAfter", DevKitBundle.message("gutter.related.option.before.after.templates", new Object[0]), DevKitIcons.Gutter.Diff);

    DescriptionTypeRelatedItemLineMarkerProvider() {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    GutterIconDescriptor.Option @NotNull [] getOptions() {
        return new GutterIconDescriptor.Option[]{this.myDescriptionOption, this.myBeforeAfterOption};
    }

    public String getName() {
        return DevKitBundle.message("gutter.related.option.name", new Object[0]);
    }

    @Override
    protected void process(@NotNull PsiElement highlightingElement, @NotNull PsiClass psiClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        boolean descriptionEnabled = this.myDescriptionOption.isEnabled();
        boolean beforeAfterEnabled = this.myBeforeAfterOption.isEnabled();
        if (!descriptionEnabled && !beforeAfterEnabled) {
            return;
        }
        if (!PsiUtil.isInstantiable(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        for (DescriptionType type : DescriptionType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)type.getClassName())) continue;
            String descriptionDirName = DescriptionCheckerUtil.getDescriptionDirName(psiClass);
            if (StringUtil.isEmptyOrSpaces((String)descriptionDirName)) {
                return;
            }
            if (type == DescriptionType.INSPECTION) {
                if (!descriptionEnabled) {
                    return;
                }
                InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
                if (info.hasDescriptionFile()) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon(highlightingElement, info.getDescriptionFile(), result);
                }
                return;
            }
            for (PsiDirectory descriptionDir : DescriptionCheckerUtil.getDescriptionsDirs(module, type)) {
                PsiFile descriptionFile;
                PsiDirectory dir = descriptionDir.findSubdirectory(descriptionDirName);
                if (dir == null || (descriptionFile = dir.findFile("description.html")) == null) continue;
                if (descriptionEnabled) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon(highlightingElement, descriptionFile, result);
                }
                if (beforeAfterEnabled) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addBeforeAfterTemplateFilesGutterIcon(highlightingElement, dir, result);
                }
                return;
            }
            return;
        }
    }

    private static void addDescriptionFileGutterIcon(PsiElement highlightingElement, PsiFile descriptionFile, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)DevKitIcons.Gutter.DescriptionFile, CONVERTER, RELATED_ITEM_PROVIDER).setTarget((Object)descriptionFile).setTooltipText(DevKitBundle.message("gutter.related.navigation.popup.description.tooltip", new Object[0])).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add(info);
    }

    private static void addBeforeAfterTemplateFilesGutterIcon(PsiElement highlightingElement, PsiDirectory descriptionDirectory, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        SortedList templateFiles = new SortedList(Comparator.comparing(PsiFileSystemItem::getName));
        for (PsiFile file : descriptionDirectory.getFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".template") || !fileName.startsWith("after.") && !fileName.startsWith("before.")) continue;
            templateFiles.add(file);
        }
        if (templateFiles.isEmpty()) {
            return;
        }
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)DevKitIcons.Gutter.Diff, CONVERTER, RELATED_ITEM_PROVIDER).setTargets((Collection)templateFiles).setPopupTitle(DevKitBundle.message("gutter.related.navigation.popup.template.title", new Object[0])).setTooltipText(DevKitBundle.message("gutter.related.navigation.popup.template.tooltip", new Object[0])).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add(info);
    }
}

