/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptionInspectionGotoRelatedProvider
extends GotoRelatedProvider {
    @NonNls
    private static final String INSPECTION_CLASS_NAME_SUFFIX = "Inspection";

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        PsiFile descriptionFile = (PsiFile)context.getData(CommonDataKeys.PSI_FILE);
        if (descriptionFile == null || descriptionFile.getFileType() != HtmlFileType.INSTANCE) {
            return Collections.emptyList();
        }
        Module module = (Module)context.getData(PlatformCoreDataKeys.MODULE);
        if (module == null) {
            return Collections.emptyList();
        }
        Project project = module.getProject();
        if (!PsiUtil.isPluginProject(project)) {
            return Collections.emptyList();
        }
        VirtualFile virtualFile = descriptionFile.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder == null || !folder.getName().equals(DescriptionType.INSPECTION.getDescriptionFolder())) {
            return Collections.emptyList();
        }
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(InspectionProfileEntry.class.getCanonicalName(), GlobalSearchScope.allScope((Project)project));
        if (baseClass == null) {
            return Collections.emptyList();
        }
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)project);
        Object possibleImplementationName = FileUtilRt.getNameWithoutExtension((String)descriptionFile.getName());
        if (!StringUtil.endsWith((CharSequence)possibleImplementationName, (CharSequence)INSPECTION_CLASS_NAME_SUFFIX)) {
            possibleImplementationName = (String)possibleImplementationName + INSPECTION_CLASS_NAME_SUFFIX;
        }
        HashSet<PsiClass> checkedPossibleImplementation = new HashSet<PsiClass>();
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            PsiClass[] possibleImplementations;
            for (PsiClass possibleImplementation : possibleImplementations = psiShortNamesCache.getClassesByName((String)possibleImplementationName, scope)) {
                if (DescriptionInspectionGotoRelatedProvider.isTargetInspectionPsiClass(possibleImplementation, descriptionFile, module)) {
                    return DescriptionInspectionGotoRelatedProvider.createGotoRelatedItem(possibleImplementation);
                }
                checkedPossibleImplementation.add(possibleImplementation);
            }
        }
        for (GlobalSearchScope scope : DescriptionCheckerUtil.searchScopes(module)) {
            Query query = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            Ref resultItems = new Ref();
            query.forEach(psiClass -> {
                if (checkedPossibleImplementation.contains(psiClass)) {
                    return true;
                }
                if (!PsiUtil.isInstantiable(psiClass)) {
                    return true;
                }
                if (DescriptionInspectionGotoRelatedProvider.isTargetInspectionPsiClass(psiClass, descriptionFile, module)) {
                    resultItems.set(DescriptionInspectionGotoRelatedProvider.createGotoRelatedItem(psiClass));
                    return false;
                }
                return true;
            });
            if (resultItems.isNull()) continue;
            return (List)resultItems.get();
        }
        return Collections.emptyList();
    }

    private static boolean isTargetInspectionPsiClass(PsiClass psiClass, PsiFile descriptionPsiFile, Module module) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        return descriptionPsiFile.equals(info.getDescriptionFile());
    }

    private static List<GotoRelatedItem> createGotoRelatedItem(PsiClass psiClass) {
        return GotoRelatedItem.createItems(Collections.singleton(psiClass));
    }
}

