/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.GeneratorAsset;
import com.intellij.ide.starters.local.GeneratorEmptyDirectory;
import com.intellij.ide.starters.local.GeneratorResourceFile;
import com.intellij.ide.starters.local.GeneratorTemplateFile;
import com.intellij.ide.starters.local.StandardAssetsProvider;
import com.intellij.ide.starters.local.Starter;
import com.intellij.ide.starters.local.StarterContextProvider;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.local.StarterPack;
import com.intellij.ide.starters.local.wizard.StarterInitialStep;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterSettings;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.lang.JavaVersion;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.IdePluginModuleBuilder;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002BCB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0014J&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0013H\u0014J\b\u0010#\u001a\u00020$H\u0014J\f\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0018H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0013H\u0014J\b\u0010-\u001a\u00020.H\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0013H\u0014J\b\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0018H\u0002J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005J\u0010\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020AH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder;", "Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "()V", "PLUGIN_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "createOptionsStep", "Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "createWizardSteps", "", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "getAssets", "", "Lcom/intellij/ide/starters/local/GeneratorAsset;", "starter", "Lcom/intellij/ide/starters/local/Starter;", "getBuilderId", "", "getDescription", "getFilePathsToOpen", "getGeneratorContextProperties", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "dependencyConfig", "Lcom/intellij/ide/starters/local/DependencyConfig;", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getMinJavaVersion", "Lcom/intellij/util/lang/JavaVersion;", "getModuleType", "Lcom/intellij/openapi/module/ModuleType;", "getNodeIcon", "Ljavax/swing/Icon;", "getPluginType", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getStarterPack", "Lcom/intellij/ide/starters/local/StarterPack;", "getTestFrameworks", "Lcom/intellij/ide/starters/shared/StarterTestRunner;", "getWeight", "", "isSuitableSdkType", "", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "sanitizeThemeFilename", "title", "setPluginType", "", "pluginType", "setupModule", "module", "Lcom/intellij/openapi/module/Module;", "setupRootModel", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "IdePluginInitialStep", "PluginType", "intellij.devkit.core"})
public final class IdePluginModuleBuilder
extends StarterModuleBuilder {
    @NotNull
    private final Key<PluginType> PLUGIN_TYPE_KEY = Key.create((String)"ide.plugin.type");

    @NotNull
    public String getBuilderId() {
        return "idea-plugin";
    }

    @NotNull
    public String getPresentableName() {
        return DevKitBundle.message("module.builder.title", new Object[0]);
    }

    public int getWeight() {
        return 1000;
    }

    @NotNull
    public Icon getNodeIcon() {
        return AllIcons.Nodes.Plugin;
    }

    @NotNull
    public String getDescription() {
        return DevKitBundle.message("module.description", new Object[0]);
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<StarterTestRunner> getTestFrameworks() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected JavaVersion getMinJavaVersion() {
        return LanguageLevel.JDK_11.toJavaVersion();
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        Object[] objectArray = new StarterLanguage[]{StarterSettings.getJAVA_STARTER_LANGUAGE(), StarterSettings.getKOTLIN_STARTER_LANGUAGE()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected StarterPack getStarterPack() {
        return new StarterPack("devkit", CollectionsKt.listOf((Object)new Starter("devkit", "DevKit", this.getDependencyConfig("/starters/devkit.pom"), CollectionsKt.emptyList())));
    }

    @NotNull
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        boolean $i$f$emptyArray = false;
        return new ModuleWizardStep[0];
    }

    @NotNull
    protected StarterInitialStep createOptionsStep(@NotNull StarterContextProvider contextProvider) {
        return new IdePluginInitialStep(contextProvider);
    }

    public boolean isSuitableSdkType(@Nullable SdkTypeId sdkType) {
        if (this.getPluginType() == PluginType.PLUGIN) {
            return super.isSuitableSdkType(sdkType);
        }
        return Intrinsics.areEqual((Object)sdkType, (Object)IdeaJdk.getInstance());
    }

    protected void setupModule(@NotNull Module module) {
        this.getStarterContext().setStarter((Starter)CollectionsKt.first((List)this.getStarterContext().getStarterPack().getStarters()));
        Map map = this.loadDependencyConfig();
        Starter starter = this.getStarterContext().getStarter();
        this.getStarterContext().setStarterDependencyConfig((DependencyConfig)map.get(starter != null ? starter.getId() : null));
        super.setupModule(module);
    }

    @NotNull
    protected List<GeneratorAsset> getAssets(@NotNull Starter starter) {
        FileTemplateManager ftManager = FileTemplateManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        List assets = new ArrayList();
        if (this.getPluginType() == PluginType.PLUGIN) {
            StandardAssetsProvider standardAssetsProvider = new StandardAssetsProvider();
            URL uRL = ((Object)((Object)this)).getClass().getResource("/assets/devkit-pluginIcon.svg");
            Intrinsics.checkNotNull((Object)uRL);
            assets.add(new GeneratorResourceFile("src/main/resources/META-INF/pluginIcon.svg", uRL));
            assets.add(new GeneratorTemplateFile("src/main/resources/META-INF/plugin.xml", ftManager.getJ2eeTemplate("devkit-plugin.xml")));
            assets.add(new GeneratorTemplateFile("build.gradle.kts", ftManager.getJ2eeTemplate("devkit-build.gradle.kts")));
            assets.add(new GeneratorTemplateFile("settings.gradle.kts", ftManager.getJ2eeTemplate("devkit-settings.gradle.kts")));
            assets.add(new GeneratorTemplateFile(standardAssetsProvider.getGradleWrapperPropertiesLocation(), ftManager.getJ2eeTemplate("devkit-gradle-wrapper.properties")));
            assets.addAll(standardAssetsProvider.getGradlewAssets());
            assets.addAll(standardAssetsProvider.getGradleIgnoreAssets());
            String packagePath = this.getPackagePath(this.getStarterContext().getGroup(), this.getStarterContext().getArtifact());
            if (Intrinsics.areEqual((Object)this.getStarterContext().getLanguage(), (Object)StarterSettings.getJAVA_STARTER_LANGUAGE())) {
                assets.add(new GeneratorEmptyDirectory("src/main/java/" + packagePath));
            } else if (Intrinsics.areEqual((Object)this.getStarterContext().getLanguage(), (Object)StarterSettings.getKOTLIN_STARTER_LANGUAGE())) {
                assets.add(new GeneratorEmptyDirectory("src/main/kotlin/" + packagePath));
            }
            URL uRL2 = ((Object)((Object)this)).getClass().getResource("/assets/devkit-Run_IDE_with_Plugin_run.xml");
            Intrinsics.checkNotNull((Object)uRL2);
            assets.add(new GeneratorResourceFile(".run/Run IDE with Plugin.run.xml", uRL2));
        } else {
            URL uRL = ((Object)((Object)this)).getClass().getResource("/assets/devkit-theme.gitignore.txt");
            Intrinsics.checkNotNull((Object)uRL);
            assets.add(new GeneratorResourceFile(".gitignore", uRL));
            URL uRL3 = ((Object)((Object)this)).getClass().getResource("/assets/devkit-pluginIcon.svg");
            Intrinsics.checkNotNull((Object)uRL3);
            assets.add(new GeneratorResourceFile("resources/META-INF/pluginIcon.svg", uRL3));
            assets.add(new GeneratorTemplateFile("resources/META-INF/plugin.xml", ftManager.getJ2eeTemplate("devkit-theme-plugin.xml")));
            assets.add(new GeneratorTemplateFile("resources/theme/" + this.sanitizeThemeFilename(this.getStarterContext().getArtifact()) + ".theme.json", ftManager.getJ2eeTemplate("devkit-theme.json")));
        }
        return assets;
    }

    @NotNull
    public ModuleType<?> getModuleType() {
        if (this.getPluginType() == PluginType.THEME) {
            return PluginModuleType.getInstance();
        }
        return super.getModuleType();
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        block3: {
            ContentEntry contentEntry;
            super.setupRootModel(modifiableRootModel);
            if (this.getPluginType() != PluginType.THEME) break block3;
            String string = this.getContentEntryPath();
            if (string == null) {
                return;
            }
            String contentEntryPath = string;
            String resourceRootPath = contentEntryPath + "/resources";
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(contentEntryPath);
            if (virtualFile == null) {
                return;
            }
            VirtualFile contentRoot = virtualFile;
            ContentEntry contentEntry2 = contentEntry = MarkRootActionBase.findContentEntry((ModuleRootModel)((ModuleRootModel)modifiableRootModel), (VirtualFile)contentRoot);
            if (contentEntry2 != null) {
                contentEntry2.addSourceFolder(VfsUtilCore.pathToUrl((String)resourceRootPath), (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            }
        }
    }

    @NotNull
    protected Map<String, String> getGeneratorContextProperties(@Nullable Sdk sdk, @NotNull DependencyConfig dependencyConfig) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginTitle", (Object)Strings.capitalize((String)this.getStarterContext().getArtifact())), TuplesKt.to((Object)"themeName", (Object)this.sanitizeThemeFilename(this.getStarterContext().getArtifact()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        if (this.getPluginType() == PluginType.THEME) {
            Object[] objectArray = new String[]{"resources/META-INF/plugin.xml", "resources/theme/" + this.sanitizeThemeFilename(this.getStarterContext().getArtifact()) + ".theme.json"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        Object[] objectArray = new String[]{"src/main/resources/META-INF/plugin.xml", "build.gradle.kts"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String sanitizeThemeFilename(String title) {
        CharSequence charSequence = StringsKt.replace$default((String)title, (String)"-", (String)"", (boolean)false, (int)4, null);
        Regex regex = StarterModuleBuilder.INVALID_PACKAGE_NAME_SYMBOL_PATTERN;
        String string = "_";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\s");
        string = "";
        return regex.replace(charSequence, string);
    }

    public final void setPluginType(@NotNull PluginType pluginType) {
        this.getStarterContext().putUserData(this.PLUGIN_TYPE_KEY, (Object)pluginType);
    }

    private final PluginType getPluginType() {
        PluginType pluginType = (PluginType)((Object)this.getStarterContext().getUserData(this.PLUGIN_TYPE_KEY));
        if (pluginType == null) {
            pluginType = PluginType.PLUGIN;
        }
        return pluginType;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$IdePluginInitialStep;", "Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "(Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder;Lcom/intellij/ide/starters/local/StarterContextProvider;)V", "typeProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "addFieldsAfter", "", "layout", "Lcom/intellij/ui/dsl/builder/Panel;", "addFieldsBefore", "intellij.devkit.core"})
    private final class IdePluginInitialStep
    extends StarterInitialStep {
        @NotNull
        private final GraphProperty<PluginType> typeProperty;

        public IdePluginInitialStep(StarterContextProvider contextProvider) {
            super(contextProvider);
            this.typeProperty = this.getPropertyGraph().property((Object)PluginType.PLUGIN);
        }

        protected void addFieldsBefore(@NotNull Panel layout) {
            layout.row(DevKitBundle.message("module.builder.type", new Object[0]), (Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ IdePluginInitialStep this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    PluginType[] pluginTypeArray = new PluginType[]{PluginType.PLUGIN, PluginType.THEME};
                    $this$row.segmentedButton((Collection)CollectionsKt.listOf((Object[])pluginTypeArray), (Function1)addFieldsBefore.1.INSTANCE).bind((ObservableMutableProperty)IdePluginInitialStep.access$getTypeProperty$p(this.this$0));
                }
            }).bottomGap(BottomGap.SMALL);
            IdePluginModuleBuilder.this.setPluginType(PluginType.PLUGIN);
            this.typeProperty.afterChange((Function1)new Function1<PluginType, Unit>(IdePluginModuleBuilder.this, this){
                final /* synthetic */ IdePluginModuleBuilder this$0;
                final /* synthetic */ IdePluginInitialStep this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull PluginType pluginType) {
                    this.this$0.setPluginType(pluginType);
                    IdePluginInitialStep.access$getLanguageRow(this.this$1).visible(pluginType == PluginType.PLUGIN);
                    IdePluginInitialStep.access$getGroupRow(this.this$1).visible(pluginType == PluginType.PLUGIN);
                    IdePluginInitialStep.access$getArtifactRow(this.this$1).visible(pluginType == PluginType.PLUGIN);
                    IdePluginInitialStep.access$getSdkComboBox(this.this$1).setSelectedJdk(null);
                    IdePluginInitialStep.access$getSdkComboBox(this.this$1).reloadModel();
                    ProjectWizardUtil.preselectJdkForNewModule((Project)IdePluginInitialStep.access$getWizardContext(this.this$1).getProject(), null, (JdkComboBox)IdePluginInitialStep.access$getSdkComboBox(this.this$1), this.this$0::isSuitableSdkType);
                }
            });
        }

        protected void addFieldsAfter(@NotNull Panel layout) {
            Panel.row$default((Panel)layout, null, (Function1)addFieldsAfter.1.INSTANCE, (int)1, null);
            Panel.row$default((Panel)layout, null, (Function1)addFieldsAfter.2.INSTANCE, (int)1, null);
            PluginId scalaPluginId = PluginId.findId((String)"org.intellij.scala");
            if (scalaPluginId != null && PluginManager.isPluginInstalled((PluginId)scalaPluginId)) {
                Panel.row$default((Panel)layout, null, (Function1)addFieldsAfter.3.INSTANCE, (int)1, null);
            }
        }

        public static final /* synthetic */ GraphProperty access$getTypeProperty$p(IdePluginInitialStep $this) {
            return $this.typeProperty;
        }

        public static final /* synthetic */ Row access$getLanguageRow(IdePluginInitialStep $this) {
            return $this.getLanguageRow();
        }

        public static final /* synthetic */ Row access$getGroupRow(IdePluginInitialStep $this) {
            return $this.getGroupRow();
        }

        public static final /* synthetic */ Row access$getArtifactRow(IdePluginInitialStep $this) {
            return $this.getArtifactRow();
        }

        public static final /* synthetic */ JdkComboBox access$getSdkComboBox(IdePluginInitialStep $this) {
            return $this.getSdkComboBox();
        }

        public static final /* synthetic */ WizardContext access$getWizardContext(IdePluginInitialStep $this) {
            return $this.getWizardContext();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/devkit/module/IdePluginModuleBuilder$PluginType;", "", "messagePointer", "Ljava/util/function/Supplier;", "", "(Ljava/lang/String;ILjava/util/function/Supplier;)V", "getMessagePointer", "()Ljava/util/function/Supplier;", "PLUGIN", "THEME", "intellij.devkit.core"})
    public static final class PluginType
    extends Enum<PluginType> {
        @NotNull
        private final Supplier<String> messagePointer;
        public static final /* enum */ PluginType PLUGIN = new PluginType(DevKitBundle.messagePointer("module.builder.type.plugin", new Object[0]));
        public static final /* enum */ PluginType THEME = new PluginType(DevKitBundle.messagePointer("module.builder.type.theme", new Object[0]));
        private static final /* synthetic */ PluginType[] $VALUES;

        private PluginType(Supplier<String> messagePointer) {
            this.messagePointer = messagePointer;
        }

        @NotNull
        public final Supplier<String> getMessagePointer() {
            return this.messagePointer;
        }

        public static PluginType[] values() {
            return (PluginType[])$VALUES.clone();
        }

        public static PluginType valueOf(String value) {
            return Enum.valueOf(PluginType.class, value);
        }

        static {
            $VALUES = pluginTypeArray = new PluginType[]{PluginType.PLUGIN, PluginType.THEME};
        }
    }
}

