/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;

class RegisterInspectionFix
implements IntentionAction {
    private final PsiClass myPsiClass;
    private final ExtensionPointName<? extends InspectionEP> myEp;

    RegisterInspectionFix(PsiClass psiClass, ExtensionPointName<? extends InspectionEP> ep) {
        this.myPsiClass = psiClass;
        this.myEp = ep;
    }

    @NotNull
    public String getText() {
        return DevKitBundle.message("register.inspection.fix.name", this.myPsiClass.getName());
    }

    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("register.inspection.fix.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !DumbService.isDumb((Project)project);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PluginDescriptorChooser.show(project, editor, file, (Consumer<? super DomFileElement<IdeaPlugin>>)((Consumer)element -> this.doFix((DomFileElement<IdeaPlugin>)element, project, file)));
    }

    private void doFix(DomFileElement<IdeaPlugin> selectedValue, Project project, PsiFile file) {
        Extension extension = (Extension)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).compute(() -> {
            Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)selectedValue, this.myEp.getName());
            Extension e = extensions.addExtension(this.myEp.getName());
            XmlTag tag = e.getXmlTag();
            tag.setAttribute("implementationClass", this.myPsiClass.getQualifiedName());
            tag.setAttribute("language", "");
            return e;
        });
        PsiNavigateUtil.navigate((PsiElement)extension.getXmlTag());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        return IntentionPreviewInfo.EMPTY;
    }
}

