/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.xml.util.IncludedXmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public final class PluginDescriptorChooser {
    private static final Map<String, String> INTELLIJ_MODULES = ContainerUtil.immutableMapBuilder().put((Object)"intellij.platform.ide", (Object)"PlatformExtensions.xml").put((Object)"intellij.platform.ide.impl", (Object)"PlatformExtensions.xml").put((Object)"intellij.platform.lang", (Object)"LangExtensions.xml").put((Object)"intellij.platform.execution.impl", (Object)"LangExtensions.xml").put((Object)"intellij.platform.lang.impl", (Object)"LangExtensions.xml").put((Object)"intellij.platform.vcs", (Object)"VcsExtensions.xml").put((Object)"intellij.platform.vcs.impl", (Object)"VcsExtensions.xml").put((Object)"intellij.java", (Object)"IdeaPlugin.xml").put((Object)"intellij.java.impl", (Object)"IdeaPlugin.xml").put((Object)"intellij.java.impl.inspections", (Object)"IdeaPlugin.xml").put((Object)"intellij.java.analysis.impl", (Object)"IdeaPlugin.xml").build();

    public static void show(Project project, Editor editor, PsiFile file, final Consumer<? super DomFileElement<IdeaPlugin>> consumer) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        List<DomFileElement<IdeaPlugin>> elements = DomService.getInstance().getFileElements(IdeaPlugin.class, project, module.getModuleWithDependentsScope());
        elements = ContainerUtil.filter((Collection)elements, element -> {
            VirtualFile virtualFile = element.getFile().getVirtualFile();
            return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
        });
        elements = PluginDescriptorChooser.findAppropriateIntelliJModule(module.getName(), elements);
        if (elements.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, DevKitBundle.message("plugin.descriptor.chooser.cannot.find", new Object[0]));
            return;
        }
        if (elements.size() == 1) {
            consumer.consume(elements.get(0));
            return;
        }
        BaseListPopupStep<PluginDescriptorCandidate> popupStep = new BaseListPopupStep<PluginDescriptorCandidate>(DevKitBundle.message("plugin.descriptor.chooser.popup.title", new Object[0]), PluginDescriptorChooser.createCandidates(module, elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(PluginDescriptorCandidate candidate) {
                return candidate.getIcon();
            }

            @NotNull
            public String getTextFor(PluginDescriptorCandidate candidate) {
                return candidate.getText();
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PluginDescriptorCandidate candidate) {
                String separatorText = candidate.getSeparatorText();
                if (separatorText != null) {
                    return new ListSeparator(separatorText);
                }
                return null;
            }

            public PopupStep onChosen(PluginDescriptorCandidate selectedValue, boolean finalChoice) {
                consumer.consume(selectedValue.myDomFileElement);
                return FINAL_CHOICE;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
    }

    @NotNull
    public static Extensions findOrCreateExtensionsForEP(DomFileElement<? extends IdeaPlugin> domFileElement, String epName) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)domFileElement.getRootElement();
        for (Extensions extensions : ideaPlugin.getExtensions()) {
            String s;
            if (extensions.getXmlTag() instanceof IncludedXmlTag || (s = extensions.getDefaultExtensionNs().getStringValue()) == null || !epName.startsWith(s)) continue;
            return extensions;
        }
        Extensions extensions = ideaPlugin.addExtensions();
        String string = StringUtil.getPackageName((String)epName);
        extensions.getDefaultExtensionNs().setStringValue(string);
        return extensions;
    }

    private static List<PluginDescriptorCandidate> createCandidates(final Module currentModule, List<? extends DomFileElement<IdeaPlugin>> elements) {
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)currentModule.getProject());
        List groupPath = grouper.getGroupPath(currentModule);
        elements.sort((o1, o2) -> {
            int groupComparison;
            Module module2;
            Module module1 = o1.getModule();
            if (!Comparing.equal((Object)module1, (Object)(module2 = o2.getModule()))) {
                if (currentModule.equals(module1)) {
                    return -1;
                }
                if (currentModule.equals(module2)) {
                    return 1;
                }
            }
            if (module1 != null && module2 != null && (groupComparison = Comparing.compare((int)PluginDescriptorChooser.groupMatchLevel(groupPath, grouper.getGroupPath(module2)), (int)PluginDescriptorChooser.groupMatchLevel(groupPath, grouper.getGroupPath(module1)))) != 0) {
                return groupComparison;
            }
            return ModulesAlphaComparator.INSTANCE.compare(module1, module2);
        });
        elements.sort((o1, o2) -> {
            if (!Comparing.equal((Object)o1.getModule(), (Object)o2.getModule())) {
                return 0;
            }
            String pluginId1 = ((IdeaPlugin)o1.getRootElement()).getPluginId();
            String pluginId2 = ((IdeaPlugin)o2.getRootElement()).getPluginId();
            if (pluginId1 == null && pluginId2 == null) {
                return o1.getFile().getName().compareTo(o2.getFile().getName());
            }
            if (pluginId1 == null) {
                return 1;
            }
            if (pluginId2 == null) {
                return -1;
            }
            return Comparing.compare((Comparable)((Object)pluginId1), (Comparable)((Object)pluginId2));
        });
        return ContainerUtil.map(elements, (Function)new Function<DomFileElement<IdeaPlugin>, PluginDescriptorCandidate>(){
            private Module myLastModule;
            {
                this.myLastModule = currentModule;
            }

            public PluginDescriptorCandidate fun(DomFileElement<IdeaPlugin> element) {
                Module module = element.getModule();
                boolean startsNewGroup = !this.myLastModule.equals(module);
                this.myLastModule = module;
                return new PluginDescriptorCandidate(element, startsNewGroup);
            }
        });
    }

    private static int groupMatchLevel(@NotNull List<String> targetGroupPath, @NotNull List<String> groupPath) {
        for (int i = 0; i < Math.min(targetGroupPath.size(), groupPath.size()); ++i) {
            if (targetGroupPath.get(i).equals(groupPath.get(i))) continue;
            return i;
        }
        return Math.min(targetGroupPath.size(), groupPath.size());
    }

    public static List<DomFileElement<IdeaPlugin>> findAppropriateIntelliJModule(String moduleName, List<DomFileElement<IdeaPlugin>> elements) {
        String extensionsFile = INTELLIJ_MODULES.get(moduleName);
        if (extensionsFile != null) {
            for (DomFileElement<IdeaPlugin> element : elements) {
                if (!element.getFile().getName().equals(extensionsFile)) continue;
                return Collections.singletonList(element);
            }
        }
        return elements;
    }

    private static final class PluginDescriptorCandidate {
        private final DomFileElement<IdeaPlugin> myDomFileElement;
        private final boolean myStartsNewGroup;

        private PluginDescriptorCandidate(DomFileElement<IdeaPlugin> domFileElement, boolean startsNewGroup) {
            this.myDomFileElement = domFileElement;
            this.myStartsNewGroup = startsNewGroup;
        }

        @NlsContexts.ListItem
        public String getText() {
            String name = this.myDomFileElement.getFile().getName();
            String pluginId = this.getPluginId();
            return pluginId != null ? name + " [" + pluginId + "]" : name;
        }

        public Icon getIcon() {
            return this.getPluginId() != null ? AllIcons.Nodes.Plugin : EmptyIcon.create((Icon)AllIcons.Nodes.Plugin);
        }

        @NlsContexts.Separator
        public String getSeparatorText() {
            if (!this.myStartsNewGroup) {
                return null;
            }
            Module module = this.myDomFileElement.getModule();
            return module == null ? null : module.getName();
        }

        @NlsSafe
        private String getPluginId() {
            return ((IdeaPlugin)this.myDomFileElement.getRootElement()).getPluginId();
        }
    }
}

