/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class AbstractRegisterFix
implements LocalQuickFix,
DescriptorUtil.Patcher {
    protected final SmartPsiElementPointer<PsiClass> myPointer;
    protected static final Logger LOG = Logger.getInstance(AbstractRegisterFix.class);

    protected AbstractRegisterFix(@NotNull PsiClass psiClass) {
        this.myPointer = SmartPointerManager.createPointer((PsiElement)psiClass);
    }

    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.component.not.registered.quickfix.family", StringUtil.toLowerCase((String)this.getType()));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        return DevKitBundle.message("inspections.component.not.registered.quickfix.name", this.getType());
    }

    protected abstract String getType();

    protected static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        @NonNls String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)ioExceptionPrefix);
        return message;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
            return;
        }
        PsiFile psiFile = this.myPointer.getContainingFile();
        PsiClass element = (PsiClass)this.myPointer.getElement();
        if (element == null) {
            LOG.info("Element is null for PsiPointer: " + this.myPointer);
            return;
        }
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        assert (module != null);
        Runnable command = () -> {
            try {
                XmlFile pluginXml = PluginModuleType.getPluginXml(module);
                if (pluginXml == null) {
                    pluginXml = DevkitActionsUtil.choosePluginModuleDescriptor(psiFile.getContainingDirectory());
                }
                if (pluginXml != null) {
                    DescriptorUtil.patchPluginXml(this, element, pluginXml);
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            }
            catch (IncorrectOperationException e) {
                Messages.showMessageDialog((Project)project, (String)AbstractRegisterFix.filterMessage(e.getMessage()), (String)DevKitBundle.message("inspections.component.not.registered.quickfix.error", this.getType()), (Icon)Messages.getErrorIcon());
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, this.getName(), null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        return IntentionPreviewInfo.EMPTY;
    }
}

