/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.inspections.missingApi.BuildNumberField;
import org.jetbrains.idea.devkit.inspections.missingApi.MissingRecentApiUsageProcessor;
import org.jetbrains.idea.devkit.inspections.missingApi.SinceUntilRange;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "sinceBuild", "Lcom/intellij/openapi/util/BuildNumber;", "getSinceBuild", "()Lcom/intellij/openapi/util/BuildNumber;", "sinceBuildString", "", "untilBuild", "getUntilBuild", "untilBuildString", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createOptionsPanel", "Ljavax/swing/JComponent;", "getSinceUntilRange", "Lorg/jetbrains/idea/devkit/inspections/missingApi/SinceUntilRange;", "pluginXml", "Lcom/intellij/psi/xml/XmlFile;", "getTargetedSinceUntilRanges", "", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.devkit.core"})
public final class MissingRecentApiInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String sinceBuildString;
    @Nullable
    private String untilBuildString;
    @NotNull
    private static final String INSPECTION_SHORT_NAME = InspectionProfileEntry.getShortName((String)MissingRecentApiInspection.class.getSimpleName());

    private final BuildNumber getSinceBuild() {
        BuildNumber buildNumber;
        String string = this.sinceBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    private final BuildNumber getUntilBuild() {
        BuildNumber buildNumber;
        String string = this.untilBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Project project = holder.getProject();
        VirtualFile virtualFile = holder.getFile().getVirtualFile();
        if (PsiUtil.isIdeaProject(project) || virtualFile != null && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        Module module2 = module;
        List<SinceUntilRange> targetedSinceUntilRanges = this.getTargetedSinceUntilRanges(module2);
        if (targetedSinceUntilRanges.isEmpty()) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new MissingRecentApiUsageProcessor(holder, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, targetedSinceUntilRanges));
    }

    @NotNull
    public JComponent createOptionsPanel() {
        BuildNumber it;
        BuildNumber buildNumber = BuildNumber.fromString((String)"1.0");
        Intrinsics.checkNotNull((Object)buildNumber);
        BuildNumber emptyBuildNumber = buildNumber;
        BuildNumberField sinceField = new BuildNumberField("since", emptyBuildNumber);
        BuildNumber buildNumber2 = this.getSinceBuild();
        if (buildNumber2 != null) {
            BuildNumber buildNumber3;
            it = buildNumber3 = buildNumber2;
            boolean bl = false;
            sinceField.setValue(it);
        }
        sinceField.getEmptyText().setText(DevKitBundle.message("inspections.missing.recent.api.settings.since.empty.text", new Object[0]));
        sinceField.getValueEditor().addListener(arg_0 -> MissingRecentApiInspection.createOptionsPanel$lambda$4(this, emptyBuildNumber, arg_0));
        BuildNumber buildNumber4 = this.getUntilBuild();
        if (buildNumber4 == null) {
            buildNumber4 = emptyBuildNumber;
        }
        BuildNumberField untilField = new BuildNumberField("until", buildNumber4);
        untilField.getEmptyText().setText(DevKitBundle.message("inspections.missing.recent.api.settings.until.empty.text", new Object[0]));
        BuildNumber buildNumber5 = this.getUntilBuild();
        if (buildNumber5 != null) {
            BuildNumber it2 = it = buildNumber5;
            boolean bl = false;
            untilField.setValue(it2);
        }
        untilField.getValueEditor().addListener(arg_0 -> MissingRecentApiInspection.createOptionsPanel$lambda$7(this, emptyBuildNumber, arg_0));
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)new JBLabel(DevKitBundle.message("inspections.missing.recent.api.settings.range", new Object[0]))).addLabeledComponent(DevKitBundle.message("inspections.missing.recent.api.settings.since", new Object[0]), (JComponent)((Object)sinceField)).addLabeledComponent(DevKitBundle.message("inspections.missing.recent.api.settings.until", new Object[0]), (JComponent)((Object)untilField));
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)formBuilder.getPanel(), "North");
        return container;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SinceUntilRange> getTargetedSinceUntilRanges(Module module) {
        if (this.getSinceBuild() == null && this.getUntilBuild() == null) {
            void $this$filterNotTo$iv$iv;
            Object it$iv$iv;
            boolean bl;
            Module it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = DevkitActionsUtil.getCandidatePluginModules(module);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (Module)element$iv$iv;
                boolean bl3 = false;
                if (PluginModuleType.getPluginXml(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (XmlFile)element$iv$iv;
                boolean bl4 = false;
                if (this.getSinceUntilRange((XmlFile)it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                SinceUntilRange it2 = (SinceUntilRange)element$iv$iv2;
                boolean bl5 = false;
                if (it2.getSinceBuild() == null) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new SinceUntilRange(this.getSinceBuild(), this.getUntilBuild()));
    }

    private final SinceUntilRange getSinceUntilRange(XmlFile pluginXml) {
        IdeaPlugin ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (ideaPlugin == null) {
            return null;
        }
        IdeaPlugin ideaPlugin2 = ideaPlugin;
        IdeaVersion ideaVersion = ideaPlugin2.getIdeaVersion();
        BuildNumber sinceBuild = (BuildNumber)ideaVersion.getSinceBuild().getValue();
        BuildNumber untilBuild = (BuildNumber)ideaVersion.getUntilBuild().getValue();
        return new SinceUntilRange(sinceBuild, untilBuild);
    }

    /*
     * WARNING - void declaration
     */
    private static final void createOptionsPanel$lambda$4(MissingRecentApiInspection this$0, BuildNumber $emptyBuildNumber, BuildNumber value) {
        void it;
        BuildNumber buildNumber;
        BuildNumber buildNumber2 = buildNumber = value;
        MissingRecentApiInspection missingRecentApiInspection = this$0;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)$emptyBuildNumber);
        Object object = bl2 ? buildNumber : null;
        missingRecentApiInspection.sinceBuildString = object != null ? object.asString() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createOptionsPanel$lambda$7(MissingRecentApiInspection this$0, BuildNumber $emptyBuildNumber, BuildNumber value) {
        void it;
        BuildNumber buildNumber;
        BuildNumber buildNumber2 = buildNumber = value;
        MissingRecentApiInspection missingRecentApiInspection = this$0;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)$emptyBuildNumber);
        Object object = bl2 ? buildNumber : null;
        missingRecentApiInspection.untilBuildString = object != null ? object.asString() : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection$Companion;", "", "()V", "INSPECTION_SHORT_NAME", "", "Lorg/jetbrains/annotations/NotNull;", "getINSPECTION_SHORT_NAME", "()Ljava/lang/String;", "intellij.devkit.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getINSPECTION_SHORT_NAME() {
            return INSPECTION_SHORT_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

