/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UseJBColorInspection
extends DevKitUastInspectionBase {
    private static final String AWT_COLOR_CLASS_NAME = Color.class.getName();
    private static final String JB_COLOR_CLASS_NAME = JBColor.class.getName();
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class, UQualifiedReferenceExpression.class, USimpleNameReferenceExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                if (expression.getKind() == UastCallKind.CONSTRUCTOR_CALL && 1.isAwtColorConstructor(expression) && 1.isJBColorClassAccessible((UElement)expression) && !1.isUsedAsJBColorConstructorParameter((UExpression)expression) && (sourcePsi = expression.getSourcePsi()) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    if (sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new ConvertToJBColorQuickFix();
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.awt.color.used", new Object[0]), fixes);
                }
                return super.visitCallExpression(expression);
            }

            private static boolean isAwtColorConstructor(@NotNull UCallExpression constructorCall) {
                return 1.isColorTypeConstructor(constructorCall, AWT_COLOR_CLASS_NAME);
            }

            private static boolean isColorTypeConstructor(@NotNull UCallExpression constructorCall, @NotNull String colorClassName) {
                PsiMethod constructor2 = constructorCall.resolve();
                if (constructor2 == null) {
                    return false;
                }
                PsiClass constructorClass = constructor2.getContainingClass();
                if (constructorClass == null) {
                    return false;
                }
                return colorClassName.equals(constructorClass.getQualifiedName());
            }

            private static boolean isJBColorClassAccessible(@NotNull UElement uElement) {
                PsiElement checkedPlace = uElement.getSourcePsi();
                if (checkedPlace == null) {
                    return false;
                }
                Project project = checkedPlace.getProject();
                PsiClass jbColorClass = JavaPsiFacade.getInstance((Project)project).findClass(JB_COLOR_CLASS_NAME, checkedPlace.getResolveScope());
                return jbColorClass != null;
            }

            private static boolean isUsedAsJBColorConstructorParameter(@NotNull UExpression expression) {
                UCallExpression containingCall = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)expression.getSourcePsi(), UCallExpression.class, (boolean)true);
                return containingCall != null && containingCall.getKind() == UastCallKind.CONSTRUCTOR_CALL && 1.isJBColorConstructor(containingCall);
            }

            private static boolean isJBColorConstructor(@NotNull UCallExpression constructorCall) {
                return 1.isColorTypeConstructor(constructorCall, JB_COLOR_CLASS_NAME);
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                if (!(node.getUastParent() instanceof UImportStatement)) {
                    this.inspectExpression((UReferenceExpression)node);
                }
                return super.visitQualifiedReferenceExpression(node);
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                this.inspectExpression((UReferenceExpression)node);
                return super.visitSimpleNameReferenceExpression(node);
            }

            private void inspectExpression(@NotNull UReferenceExpression expression) {
                PsiElement sourcePsi;
                if (1.isAwtColorConstantReference(expression) && 1.isJBColorClassAccessible((UElement)expression) && !1.isUsedAsJBColorConstructorParameter((UExpression)expression) && (sourcePsi = expression.getSourcePsi()) != null) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.awt.color.used", new Object[0]), new LocalQuickFix[]{new ConvertToJBColorConstantQuickFix()});
                }
            }

            private static boolean isAwtColorConstantReference(@NotNull UReferenceExpression expression) {
                if (expression.getUastParent() instanceof UQualifiedReferenceExpression) {
                    return false;
                }
                PsiElement colorField = expression.resolve();
                if (colorField instanceof PsiField && ((PsiField)colorField).hasModifierProperty("static")) {
                    PsiClass colorClass = ((PsiField)colorField).getContainingClass();
                    return colorClass != null && AWT_COLOR_CLASS_NAME.equals(colorClass.getQualifiedName());
                }
                return false;
            }
        }, (Class[])HINTS);
    }

    private static class ConvertToJBColorQuickFix
    implements LocalQuickFix {
        private ConvertToJBColorQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.awt.color.used.fix.use.jb.color.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String newJBColor = String.format("new %s(%s, new java.awt.Color())", JBColor.class.getName(), element.getText());
            PsiExpression expression = factory.createExpressionFromText(newJBColor, element.getContext());
            PsiElement newElement = element.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private static class ConvertToJBColorConstantQuickFix
    implements LocalQuickFix {
        private ConvertToJBColorConstantQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.awt.color.used.fix.use.jb.color.constant.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String jbColorConstant;
            PsiElement element = descriptor.getPsiElement();
            UReferenceExpression awtColorConstantReference = ConvertToJBColorConstantQuickFix.getReferenceExpression(element);
            if (awtColorConstantReference == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UQualifiedReferenceExpression jbColorConstantReference = pluginElementFactory.createQualifiedReference(jbColorConstant = JBColor.class.getName() + "." + ConvertToJBColorConstantQuickFix.buildColorConstantName(element), element);
            if (jbColorConstantReference != null) {
                generationPlugin.replace((UElement)awtColorConstantReference, (UElement)jbColorConstantReference, UQualifiedReferenceExpression.class);
            }
        }

        @Nullable
        private static UReferenceExpression getReferenceExpression(PsiElement element) {
            UReferenceExpression expression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, UQualifiedReferenceExpression.class);
            if (expression == null) {
                expression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, USimpleNameReferenceExpression.class);
            }
            return expression;
        }

        @NotNull
        @NonNls
        private static String buildColorConstantName(@NotNull PsiElement expression) {
            @NonNls String text = expression.getText();
            if (text.contains(".")) {
                text = text.substring(text.lastIndexOf(46));
            }
            if ((text = StringUtil.trimStart((String)text, (String)".")).equalsIgnoreCase("lightGray")) {
                text = "LIGHT_GRAY";
            } else if (text.equalsIgnoreCase("darkGray")) {
                text = "DARK_GRAY";
            }
            return StringUtil.toUpperCase((String)text);
        }
    }
}

