/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

abstract class UseEqualsInspectionBase
extends DevKitUastInspectionBase {
    public static final Class<? extends UElement>[] HINTS = new Class[]{UBinaryExpression.class};

    UseEqualsInspectionBase() {
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        return super.isAllowed(holder) && JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(this.getTargetClass().getName(), holder.getFile().getResolveScope()) != null;
    }

    @NotNull
    protected abstract Class<?> getTargetClass();

    @Override
    @NotNull
    protected final PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression binaryExpression) {
                UastBinaryOperator operator = binaryExpression.getOperator();
                if (UseEqualsInspectionBase.isIdentityComparison(operator) && UseEqualsInspectionBase.this.isNotExcluded(binaryExpression)) {
                    PsiElement sourcePsi = binaryExpression.getSourcePsi();
                    if (sourcePsi == null) {
                        return true;
                    }
                    String operatorText = UseEqualsInspectionBase.getOperatorText(binaryExpression);
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.equals.description", UseEqualsInspectionBase.this.getTargetClass().getSimpleName()), UseEqualsInspectionBase.createFix(operatorText, operator == UastBinaryOperator.IDENTITY_NOT_EQUALS, sourcePsi.getLanguage()));
                }
                return true;
            }
        }, (Class[])HINTS);
    }

    private static boolean isIdentityComparison(@NotNull UastBinaryOperator operator) {
        return operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS;
    }

    private boolean isNotExcluded(@NotNull UBinaryExpression binaryExpression) {
        UExpression leftOperand = binaryExpression.getLeftOperand();
        if (this.isExcluded(leftOperand)) {
            return false;
        }
        UExpression rightOperand = binaryExpression.getRightOperand();
        if (this.isExcluded(rightOperand)) {
            return false;
        }
        return this.hasTargetType(leftOperand) || this.hasTargetType(rightOperand);
    }

    private static String getOperatorText(@NotNull UBinaryExpression binaryExpression) {
        UIdentifier identifier = binaryExpression.getOperatorIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiElement identifierSourcePsi = identifier.getSourcePsi();
        if (identifierSourcePsi == null) {
            return null;
        }
        return identifierSourcePsi.getText();
    }

    protected boolean isExcluded(@NotNull UExpression operand) {
        return operand instanceof ULiteralExpression || operand instanceof UThisExpression;
    }

    private boolean hasTargetType(@NotNull UExpression operand) {
        return operand.getSourcePsi() != null && InheritanceUtil.isInheritor((PsiType)operand.getExpressionType(), (String)this.getTargetClass().getName());
    }

    private static LocalQuickFix @NotNull [] createFix(String operatorText, boolean negated, Language language) {
        if (language.is((Language)JavaLanguage.INSTANCE)) {
            return new LocalQuickFix[]{new ReplaceIdentityWithEqualsComparisonFix(operatorText, negated)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static class ReplaceIdentityWithEqualsComparisonFix
    implements LocalQuickFix {
        private final String myCurrentOperator;
        protected final boolean myNegated;

        ReplaceIdentityWithEqualsComparisonFix(String currentOperator, boolean negated) {
            this.myCurrentOperator = currentOperator;
            this.myNegated = negated;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            if (rOperand == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String lText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)lOperand));
            String rText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)rOperand));
            @NonNls String expString = (this.myNegated ? "!" : "") + lText + ".equals(" + rText + ")";
            PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, (String)expString, (CommentTracker)commentTracker);
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myNegated ? DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.not.equals.name", this.myCurrentOperator) : DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.equals.name", this.myCurrentOperator);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.equals.family.name", new Object[0]);
        }
    }
}

