/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.internal.AbstractUseDPIAwareBorderInspection;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastCallKind;

public class UseDPIAwareInsetsInspection
extends AbstractUseDPIAwareBorderInspection {
    private static final String AWT_INSETS_CLASS_NAME = Insets.class.getName();
    private static final String JB_INSETS_CLASS_NAME = JBInsets.class.getName();
    private static final String JB_UI_CLASS_NAME = JBUI.class.getName();

    @Override
    protected boolean isAllowedConstructorCall(@NotNull UCallExpression expression) {
        UCallExpression containingCall;
        UElement parent = expression.getUastParent();
        if (!(parent instanceof UCallExpression) || (containingCall = (UCallExpression)parent).getKind() != UastCallKind.METHOD_CALL) {
            return false;
        }
        PsiType type = containingCall.getReturnType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolvedClass = classType.resolve();
        if (resolvedClass == null) {
            return false;
        }
        return JB_INSETS_CLASS_NAME.equals(resolvedClass.getQualifiedName());
    }

    @Override
    @NotNull
    protected String getFactoryMethodContainingClassName() {
        return JB_UI_CLASS_NAME;
    }

    @Override
    @NotNull
    protected String getFactoryMethodName() {
        return "insets";
    }

    @Override
    @NotNull
    protected String getNonDpiAwareClassName() {
        return AWT_INSETS_CLASS_NAME;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getCanBeSimplifiedMessage() {
        return DevKitBundle.message("inspections.use.dpi.aware.insets.can.be.simplified", new Object[0]);
    }

    @Override
    @NotNull
    protected LocalQuickFix createSimplifyFix() {
        return new SimplifyJBUIInsetsCreationQuickFix();
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getNonDpiAwareObjectCreatedMessage() {
        return DevKitBundle.message("inspections.use.dpi.aware.insets.not.dpi.aware", new Object[0]);
    }

    @Override
    @NotNull
    protected LocalQuickFix createConvertToDpiAwareMethodCall() {
        return new ConvertToJBUIInsetsQuickFix();
    }

    private static class SimplifyJBUIInsetsCreationQuickFix
    extends AbstractConvertToDpiAwareInsetsQuickFix {
        private SimplifyJBUIInsetsCreationQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.dpi.aware.insets.simplify.fix.name", new Object[0]);
        }
    }

    private static class ConvertToJBUIInsetsQuickFix
    extends AbstractConvertToDpiAwareInsetsQuickFix {
        private ConvertToJBUIInsetsQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.dpi.aware.insets.convert.fix.name", new Object[0]);
        }
    }

    private static abstract class AbstractConvertToDpiAwareInsetsQuickFix
    extends AbstractUseDPIAwareBorderInspection.AbstractConvertToDpiAwareCallQuickFix {
        private AbstractConvertToDpiAwareInsetsQuickFix() {
        }

        @Override
        @NotNull
        protected String getFactoryMethodContainingClassName() {
            return JB_UI_CLASS_NAME;
        }

        @Override
        @NotNull
        protected String getEmptyFactoryMethodName() {
            return "emptyInsets";
        }

        @Override
        @NotNull
        protected String getTopFactoryMethodName() {
            return "insetsTop";
        }

        @Override
        @NotNull
        protected String getBottomFactoryMethodName() {
            return "insetsBottom";
        }

        @Override
        @NotNull
        protected String getLeftFactoryMethodName() {
            return "insetsLeft";
        }

        @Override
        @NotNull
        protected String getRightFactoryMethodName() {
            return "insetsRight";
        }

        @Override
        @NotNull
        protected String getAllSameFactoryMethodName() {
            return "insets";
        }

        @Override
        @NotNull
        protected String getTopBottomAndLeftRightSameFactoryMethodName() {
            return "insets";
        }

        @Override
        @NotNull
        protected String getAllDifferentFactoryMethodName() {
            return "insets";
        }
    }
}

