/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.util.ui.JBUI;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.internal.AbstractUseDPIAwareBorderInspection;
import org.jetbrains.uast.UCallExpression;

public class UseDPIAwareEmptyBorderInspection
extends AbstractUseDPIAwareBorderInspection {
    private static final String SWING_EMPTY_BORDER_CLASS_NAME = EmptyBorder.class.getName();
    private static final String JB_UI_CLASS_NAME = JBUI.class.getName();
    private static final String JB_UI_BORDERS_CLASS_NAME = JB_UI_CLASS_NAME + ".Borders";

    @Override
    protected boolean isAllowedConstructorCall(@NotNull UCallExpression expression) {
        return false;
    }

    @Override
    @NotNull
    protected String getFactoryMethodContainingClassName() {
        return JB_UI_BORDERS_CLASS_NAME;
    }

    @Override
    @NotNull
    protected String getFactoryMethodName() {
        return "empty";
    }

    @Override
    @NotNull
    protected String getNonDpiAwareClassName() {
        return SWING_EMPTY_BORDER_CLASS_NAME;
    }

    @Override
    @NotNull
    protected String getCanBeSimplifiedMessage() {
        return DevKitBundle.message("inspections.use.dpi.aware.empty.border.can.be.simplified", new Object[0]);
    }

    @Override
    @NotNull
    protected LocalQuickFix createSimplifyFix() {
        return new SimplifyJBUIEmptyBorderCreationQuickFix();
    }

    @Override
    @NotNull
    protected String getNonDpiAwareObjectCreatedMessage() {
        return DevKitBundle.message("inspections.use.dpi.aware.empty.border.not.dpi.aware", new Object[0]);
    }

    @Override
    @NotNull
    protected LocalQuickFix createConvertToDpiAwareMethodCall() {
        return new ConvertToJBUIBorderQuickFix();
    }

    private static class SimplifyJBUIEmptyBorderCreationQuickFix
    extends AbstractConvertToDpiAwareBorderQuickFix {
        private SimplifyJBUIEmptyBorderCreationQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.dpi.aware.empty.border.simplify.fix.name", new Object[0]);
        }
    }

    private static class ConvertToJBUIBorderQuickFix
    extends AbstractConvertToDpiAwareBorderQuickFix {
        private ConvertToJBUIBorderQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.dpi.aware.empty.border.convert.fix.name", new Object[0]);
        }
    }

    private static abstract class AbstractConvertToDpiAwareBorderQuickFix
    extends AbstractUseDPIAwareBorderInspection.AbstractConvertToDpiAwareCallQuickFix {
        private AbstractConvertToDpiAwareBorderQuickFix() {
        }

        @Override
        @NotNull
        protected String getFactoryMethodContainingClassName() {
            return JB_UI_BORDERS_CLASS_NAME;
        }

        @Override
        @NotNull
        protected String getEmptyFactoryMethodName() {
            return "empty";
        }

        @Override
        @NotNull
        protected String getTopFactoryMethodName() {
            return "emptyTop";
        }

        @Override
        @NotNull
        protected String getBottomFactoryMethodName() {
            return "emptyBottom";
        }

        @Override
        @NotNull
        protected String getLeftFactoryMethodName() {
            return "emptyLeft";
        }

        @Override
        @NotNull
        protected String getRightFactoryMethodName() {
            return "emptyRight";
        }

        @Override
        @NotNull
        protected String getAllSameFactoryMethodName() {
            return "empty";
        }

        @Override
        @NotNull
        protected String getTopBottomAndLeftRightSameFactoryMethodName() {
            return "empty";
        }

        @Override
        @NotNull
        protected String getAllDifferentFactoryMethodName() {
            return "empty";
        }
    }
}

