/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UnsafeVfsRecursionInspection
extends DevKitUastInspectionBase {
    private static final String VIRTUAL_FILE_CLASS_NAME = VirtualFile.class.getName();
    private static final String GET_CHILDREN_METHOD_NAME = "getChildren";
    private static final String GET_CHILDREN_PROPERTY_ACCESS_NAME = "children";
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class, UQualifiedReferenceExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                UnsafeVfsRecursionInspection.inspectExpression((UExpression)node, holder);
                return true;
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                UnsafeVfsRecursionInspection.inspectExpression((UExpression)node, holder);
                return true;
            }
        }, (Class[])HINTS);
    }

    private static void inspectExpression(@NotNull UExpression expression, @NotNull ProblemsHolder holder) {
        PsiElement sourcePsi;
        if (UnsafeVfsRecursionInspection.isVirtualFileGetChildrenMethodCall(expression) && UnsafeVfsRecursionInspection.isCalledInRecursiveMethod(expression) && (sourcePsi = expression.getSourcePsi()) != null) {
            holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.unsafe.vfs.recursion", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isVirtualFileGetChildrenMethodCall(@NotNull UExpression expression) {
        PsiMethod getChildrenMethod = UnsafeVfsRecursionInspection.tryToResolveGetVisitChildrenMethod(expression);
        if (getChildrenMethod == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)getChildrenMethod.getContainingClass(), (String)VIRTUAL_FILE_CLASS_NAME);
    }

    @Nullable
    private static PsiMethod tryToResolveGetVisitChildrenMethod(@NotNull UExpression expression) {
        UCallExpression methodCall;
        if (expression instanceof UCallExpression && UastExpressionUtils.isMethodCall((UElement)(methodCall = (UCallExpression)expression))) {
            if (GET_CHILDREN_METHOD_NAME.equals(methodCall.getMethodName())) {
                return methodCall.resolve();
            }
        } else if (expression instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression qualifiedReference = (UQualifiedReferenceExpression)expression;
            PsiElement selectorPsi = qualifiedReference.getSelector().getSourcePsi();
            if (selectorPsi == null) {
                return null;
            }
            if (GET_CHILDREN_PROPERTY_ACCESS_NAME.equals(selectorPsi.getText())) {
                PsiElement resolveResult = qualifiedReference.resolve();
                return resolveResult instanceof PsiMethod ? (PsiMethod)resolveResult : null;
            }
        }
        return null;
    }

    private static boolean isCalledInRecursiveMethod(final @NotNull UExpression getChildrenMethodCall) {
        final UMethod containingMethod = (UMethod)UastUtils.getParentOfType((UElement)getChildrenMethodCall, UMethod.class);
        if (containingMethod == null) {
            return false;
        }
        final String containingMethodName = containingMethod.getName();
        final Ref isInRecursiveCall = Ref.create();
        PsiElement methodSourcePsi = containingMethod.getSourcePsi();
        if (methodSourcePsi == null) {
            return false;
        }
        methodSourcePsi.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                UCallExpression potentialRecursiveCall = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                if (potentialRecursiveCall == null) {
                    return;
                }
                if (!UastExpressionUtils.isMethodCall((UElement)potentialRecursiveCall)) {
                    return;
                }
                if (potentialRecursiveCall != getChildrenMethodCall && containingMethodName.equals(potentialRecursiveCall.getMethodName()) && 2.expressionResolvesToMethod(potentialRecursiveCall, containingMethod)) {
                    isInRecursiveCall.set((Object)Boolean.TRUE);
                }
            }

            private static boolean expressionResolvesToMethod(@NotNull UCallExpression potentialRecursiveCall, @NotNull UMethod uMethod) {
                PsiMethod resolvedMethod = potentialRecursiveCall.resolve();
                if (resolvedMethod == null) {
                    return false;
                }
                UElement resolvedUMethod = UastContextKt.toUElement((PsiElement)resolvedMethod);
                if (resolvedUMethod == null) {
                    return false;
                }
                return uMethod.getSourcePsi() == resolvedUMethod.getSourcePsi();
            }
        });
        return Boolean.TRUE == isInRecursiveCall.get();
    }
}

