/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

public class UnsafeReturnStatementVisitorInspection
extends DevKitUastInspectionBase {
    @NonNls
    private static final String BASE_WALKING_VISITOR_NAME = JavaRecursiveElementWalkingVisitor.class.getName();
    @NonNls
    private static final String BASE_VISITOR_NAME = JavaRecursiveElementVisitor.class.getName();
    @NonNls
    private static final String EMPTY_VISIT_LAMBDA_METHOD = "public void visitLambdaExpression(PsiLambdaExpression expression) {}";
    @NonNls
    private static final String EMPTY_VISIT_CLASS_METHOD = "public void visitClass(PsiClass aClass) {}";

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiClass aClass = uClass.getJavaPsi();
        if ((InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_WALKING_VISITOR_NAME) || InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_VISITOR_NAME)) && UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitReturnStatement", PsiReturnStatement.class.getName())) {
            PsiElement classNameAnchor;
            boolean visitClassMissing;
            boolean visitLambdaMissing = !UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitLambdaExpression", PsiLambdaExpression.class.getName());
            boolean bl = visitClassMissing = !UnsafeReturnStatementVisitorInspection.hasMethod(uClass, "visitClass", PsiClass.class.getName());
            if ((visitLambdaMissing || visitClassMissing) && (classNameAnchor = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor())) != null) {
                ProblemsHolder holder = UnsafeReturnStatementVisitorInspection.createProblemsHolder((UElement)uClass, manager, isOnTheFly);
                holder.registerProblem(classNameAnchor, DevKitBundle.message("inspections.unsafe.return.message", new Object[0]), UnsafeReturnStatementVisitorInspection.createFixes(uClass, visitLambdaMissing, visitClassMissing));
                return holder.getResultsArray();
            }
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static boolean hasMethod(UClass uClass, String visitMethodName, String argumentType) {
        return ContainerUtil.exists((Object[])uClass.getMethods(), uMethod -> visitMethodName.equals(uMethod.getName()) && UnsafeReturnStatementVisitorInspection.hasSingleParameterOfType(uMethod, argumentType));
    }

    private static boolean hasSingleParameterOfType(UMethod uMethod, String argumentType) {
        List parameters = uMethod.getUastParameters();
        return parameters.size() == 1 && ((UParameter)parameters.get(0)).getType().equalsToText(argumentType);
    }

    private static LocalQuickFix[] createFixes(@NotNull UClass uClass, boolean visitLambdaMissing, boolean visitClassMissing) {
        String[] methodsToInsert;
        String fixName;
        if (!uClass.getLang().is((Language)JavaLanguage.INSTANCE)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (visitLambdaMissing && visitClassMissing) {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression.and.class.methods", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_LAMBDA_METHOD, EMPTY_VISIT_CLASS_METHOD};
        } else if (visitLambdaMissing) {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_LAMBDA_METHOD};
        } else {
            fixName = DevKitBundle.message("inspections.unsafe.return.insert.visit.class.method", new Object[0]);
            methodsToInsert = new String[]{EMPTY_VISIT_CLASS_METHOD};
        }
        return new LocalQuickFix[]{new MySkipVisitFix(fixName, methodsToInsert)};
    }

    private static class MySkipVisitFix
    implements LocalQuickFix {
        @IntentionName
        private final String myName;
        private final String[] myMethods;

        MySkipVisitFix(@IntentionName String name, String[] methods) {
            this.myName = name;
            this.myMethods = methods;
        }

        @IntentionName
        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.unsafe.return.insert.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            if (aClass != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (String methodText : this.myMethods) {
                    PsiMethod method = factory.createMethodFromText(methodText, (PsiElement)aClass);
                    PsiMethod overridden = aClass.findMethodBySignature(method, true);
                    if (overridden != null) {
                        OverrideImplementUtil.annotateOnOverrideImplement((PsiMethod)method, (PsiClass)aClass, (PsiMethod)overridden);
                    }
                    aClass.add((PsiElement)method);
                }
            }
        }
    }
}

