/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterExtensionFix;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

public class StatisticsCollectorNotRegisteredInspection
extends DevKitJvmInspection {
    public static final String FEATURE_USAGES_COLLECTOR = "com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector";

    @Nullable
    protected JvmElementVisitor<Boolean> buildVisitor(final @NotNull Project project, final @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        return new DefaultJvmElementVisitor<Boolean>(){

            public Boolean visitClass(@NotNull JvmClass clazz) {
                PsiElement sourceElement = clazz.getSourceElement();
                if (!(sourceElement instanceof PsiClass)) {
                    return null;
                }
                StatisticsCollectorNotRegisteredInspection.checkClass(project, (PsiClass)sourceElement, sink);
                return false;
            }
        };
    }

    private static void checkClass(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum()) {
            return;
        }
        GlobalSearchScope scope = checkedClass.getResolveScope();
        PsiClass featureUsageCollectorClass = JavaPsiFacade.getInstance((Project)project).findClass(FEATURE_USAGES_COLLECTOR, scope);
        if (featureUsageCollectorClass != null && checkedClass.isInheritor(featureUsageCollectorClass, true)) {
            for (StatisticsCollectorType collectorType : StatisticsCollectorType.values()) {
                if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)collectorType.getClassName())) continue;
                StatisticsCollectorNotRegisteredInspection.checkCollectorRegistration(project, checkedClass, sink, collectorType);
                return;
            }
        }
    }

    private static void checkCollectorRegistration(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink, @NotNull StatisticsCollectorType collectorType) {
        String qualifiedName = ClassUtil.getJVMClassName((PsiClass)checkedClass);
        if (qualifiedName == null) {
            return;
        }
        AtomicBoolean isCollectorRegistered = new AtomicBoolean(false);
        ExtensionLocatorKt.processExtensionDeclarations(StatisticsCollectorNotRegisteredInspection.getNameToSearch(checkedClass, qualifiedName), project, false, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)(extension, tag) -> {
            ExtensionPoint point = extension.getExtensionPoint();
            if (point != null && point.getEffectiveQualifiedName().equals(collectorType.getExtensionPoint()) && ContainerUtil.exists((Object[])tag.getAttributes(), it -> Objects.equals(it.getValue(), qualifiedName))) {
                isCollectorRegistered.set(true);
                return false;
            }
            return true;
        }));
        if (isCollectorRegistered.get()) {
            return;
        }
        ExtensionPointLocator extensionPointLocator = new ExtensionPointLocator(checkedClass);
        Set<ExtensionPointCandidate> candidateList = extensionPointLocator.findSuperCandidates();
        if (!candidateList.isEmpty()) {
            RegisterExtensionFix fix = new RegisterExtensionFix(checkedClass, candidateList);
            sink.highlight(DevKitBundle.message("inspections.statistics.collector.not.registered.message", new Object[0]), new LocalQuickFix[]{fix});
        }
    }

    @NotNull
    private static String getNameToSearch(@NotNull PsiClass checkedClass, String qualifiedName) {
        PsiClass parentClass = (PsiClass)ObjectUtils.tryCast((Object)checkedClass.getParent(), PsiClass.class);
        if (parentClass == null) {
            return qualifiedName;
        }
        String parentQualifiedName = parentClass.getQualifiedName();
        return parentQualifiedName != null ? parentQualifiedName : qualifiedName;
    }

    private static enum StatisticsCollectorType {
        COUNTER("com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector", "com.intellij.statistics.counterUsagesCollector"),
        PROJECT("com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector", "com.intellij.statistics.projectUsagesCollector"),
        APPLICATION("com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector", "com.intellij.statistics.applicationUsagesCollector");

        private final String myClassName;
        private final String myExtensionPoint;

        private StatisticsCollectorType(String className, String extensionPoint) {
            this.myClassName = className;
            this.myExtensionPoint = extensionPoint;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getExtensionPoint() {
            return this.myExtensionPoint;
        }
    }
}

