/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

public class SerializableCtorInspection
extends DevKitUastInspectionBase {
    private static final String PROPERTY_MAPPING_ANNOTATION = "com.intellij.serialization.PropertyMapping";

    public SerializableCtorInspection() {
        super(UClass.class);
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        return super.isAllowed(holder) && SerializableCtorInspection.propertyMappingAnnotationPresent(holder);
    }

    private static boolean propertyMappingAnnotationPresent(@NotNull ProblemsHolder holder) {
        Project project = holder.getProject();
        return JavaPsiFacade.getInstance((Project)project).findClass(PROPERTY_MAPPING_ANNOTATION, holder.getFile().getResolveScope()) != null;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!InheritanceUtil.isInheritor((PsiClass)aClass.getJavaPsi(), (String)"java.io.Serializable")) {
            return null;
        }
        if (!SerializableCtorInspection.hasFieldWithName(aClass, "serialVersionUID")) {
            return null;
        }
        ProblemsHolder holder = SerializableCtorInspection.createProblemsHolder((UElement)aClass, manager, isOnTheFly);
        for (UMethod constructor2 : SerializableCtorInspection.getConstructors(aClass)) {
            PsiElement constructorAnchor;
            if (SerializableCtorInspection.isAnnotatedWithPropertyMapping(constructor2) || (constructorAnchor = UElementKt.getSourcePsiElement((UElement)constructor2.getUastAnchor())) == null) continue;
            holder.registerProblem(constructorAnchor, DevKitBundle.message("inspection.serializable.constructor.message", new Object[0]), SerializableCtorInspection.createFixes(aClass, holder, constructor2));
        }
        return holder.getResultsArray();
    }

    private static boolean hasFieldWithName(@NotNull UClass aClass, @NotNull String name) {
        return ContainerUtil.exists((Object[])aClass.getFields(), field -> name.equals(field.getName()));
    }

    @NotNull
    private static List<UMethod> getConstructors(@NotNull UClass aClass) {
        return ContainerUtil.filter((Object[])aClass.getMethods(), method -> method.isConstructor());
    }

    private static boolean isAnnotatedWithPropertyMapping(UMethod constructor2) {
        return ContainerUtil.exists((Iterable)constructor2.getUAnnotations(), annotation -> PROPERTY_MAPPING_ANNOTATION.equals(annotation.getQualifiedName()));
    }

    private static LocalQuickFix[] createFixes(@NotNull UClass aClass, ProblemsHolder holder, UMethod constructor2) {
        return IntentionWrapper.wrapToQuickFixes((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)constructor2.getJavaPsi(), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)PROPERTY_MAPPING_ANNOTATION, (AnnotationAttributeRequest[])SerializableCtorInspection.createExpectedAnnotationAttributes(holder.getProject(), aClass, constructor2))), (PsiFile)Objects.requireNonNull(aClass.getSourcePsi()).getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static AnnotationAttributeRequest @NotNull [] createExpectedAnnotationAttributes(Project project, UClass aClass, UMethod constructor2) {
        @NonNls StringBuilder builder2 = new StringBuilder("@PropertyMapping({");
        List parameters = constructor2.getUastParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Object name;
            if (i > 0) {
                builder2.append(',');
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)(name = Objects.requireNonNull(((UParameter)parameters.get(i)).getName())))) {
                name = "my" + StringUtil.capitalize((String)name);
            }
            if (!SerializableCtorInspection.hasFieldWithName(aClass, (String)name)) {
                name = "??" + (String)name;
            }
            builder2.append('\"').append((String)name).append('\"');
        }
        builder2.append("})");
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(builder2.toString(), aClass.getSourcePsi());
        return (AnnotationAttributeRequest[])AnnotationAttributeValueRequestKt.attributeRequests((JvmAnnotation)annotation).toArray(AnnotationAttributeRequest[]::new);
    }
}

