/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.internal.GoodCodeRedVisitor;

public abstract class GoodCodeRedInspectionTool
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (isOnTheFly) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        PsiFile file = holder.getFile();
        if (InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null || CompilerConfiguration.getInstance((Project)holder.getProject()).isExcludedFromCompilation(virtualFile)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        GoodCodeRedVisitor visitor = this.getGoodCodeRedVisitor(file);
        if (visitor == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return visitor.createVisitor(holder);
    }

    @Nullable
    protected abstract GoodCodeRedVisitor getGoodCodeRedVisitor(@NotNull PsiFile var1);
}

