/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class FileEqualsUsageInspection
extends DevKitUastInspectionBase {
    private static final Set<String> METHOD_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"equals", "compareTo", "hashCode"});

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                FileEqualsUsageInspection.inspectCallExpression(node, holder);
                return true;
            }
        }, (Class[])new Class[]{UCallExpression.class});
    }

    private static void inspectCallExpression(@NotNull UCallExpression node, @NotNull ProblemsHolder holder) {
        if (node.getKind() != UastCallKind.METHOD_CALL) {
            return;
        }
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"java.io.File".equals(containingClass.getQualifiedName())) {
            return;
        }
        if (!METHOD_NAMES.contains(node.getMethodName())) {
            return;
        }
        if (JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(FileUtil.class.getName(), holder.getFile().getResolveScope()) == null) {
            return;
        }
        UIdentifier identifier = node.getMethodIdentifier();
        if (identifier == null) {
            return;
        }
        PsiElement sourcePsi = identifier.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.file.equals.method", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
    }
}

