/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UseGrayInspection
extends DevKitUastInspectionBase {
    private static final String AWT_COLOR_CLASS_NAME = Color.class.getName();
    private static final String GRAY_CLASS_NAME = Gray.class.getName();
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                Integer grayValue;
                if (expression.getKind() == UastCallKind.CONSTRUCTOR_CALL && UseGrayInspection.isAwtRgbColorConstructor(expression) && (grayValue = UseGrayInspection.getGrayValue(expression)) != null && (sourcePsi = expression.getSourcePsi()) != null && UseGrayInspection.grayClassAccessible(sourcePsi)) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.gray.awt.color.used.name", new Object[0]), new LocalQuickFix[]{new ConvertToGrayQuickFix(grayValue)});
                }
                return super.visitCallExpression(expression);
            }
        }, (Class[])HINTS);
    }

    private static boolean isAwtRgbColorConstructor(@NotNull UCallExpression constructorCall) {
        List constructorParams = constructorCall.getValueArguments();
        if (constructorParams.size() != 3) {
            return false;
        }
        PsiMethod constructor2 = constructorCall.resolve();
        if (constructor2 == null) {
            return false;
        }
        PsiClass constructorClass = constructor2.getContainingClass();
        if (constructorClass == null) {
            return false;
        }
        return AWT_COLOR_CLASS_NAME.equals(constructorClass.getQualifiedName());
    }

    @Nullable
    private static Integer getGrayValue(@NotNull UCallExpression constructorCall) {
        List constructorParams = constructorCall.getValueArguments();
        UExpression redParam = (UExpression)constructorParams.get(0);
        Integer red = UseGrayInspection.evaluateColorValue(redParam);
        if (red == null) {
            return null;
        }
        UExpression greenParam = (UExpression)constructorParams.get(1);
        UExpression blueParam = (UExpression)constructorParams.get(2);
        return 0 <= red && red < 256 && red.equals(UseGrayInspection.evaluateColorValue(greenParam)) && red.equals(UseGrayInspection.evaluateColorValue(blueParam)) ? red : null;
    }

    @Nullable
    private static Integer evaluateColorValue(@NotNull UExpression expression) {
        Object evaluatedExpression = expression.evaluate();
        if (evaluatedExpression instanceof Integer) {
            Integer value = (Integer)evaluatedExpression;
            return value;
        }
        return null;
    }

    private static boolean grayClassAccessible(@NotNull PsiElement checkedPlace) {
        return JavaPsiFacade.getInstance((Project)checkedPlace.getProject()).findClass(GRAY_CLASS_NAME, checkedPlace.getResolveScope()) != null;
    }

    @NotNull
    public String getShortName() {
        return "InspectionUsingGrayColors";
    }

    private static class ConvertToGrayQuickFix
    implements LocalQuickFix {
        private final int myGrayValue;

        private ConvertToGrayQuickFix(int grayValue) {
            this.myGrayValue = grayValue;
        }

        @IntentionName
        @NotNull
        public String getName() {
            return DevKitBundle.message("inspections.use.gray.fix.convert.name", this.myGrayValue);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.use.gray.fix.convert.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String grayConstant;
            PsiElement element = descriptor.getPsiElement();
            UCallExpression awtGrayColorConstructor = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
            if (awtGrayColorConstructor == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UQualifiedReferenceExpression grayConstantReference = pluginElementFactory.createQualifiedReference(grayConstant = Gray.class.getName() + "._" + this.myGrayValue, element);
            if (grayConstantReference == null) {
                return;
            }
            generationPlugin.replace((UElement)awtGrayColorConstructor, (UElement)grayConstantReference, UQualifiedReferenceExpression.class);
        }
    }
}

