/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UnspecifiedActionsPlaceInspection
extends DevKitUastInspectionBase {
    private static final boolean SKIP_CHILDREN = true;
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class};
    public static final String CREATE_ACTION_TOOLBAR_METHOD_NAME = "createActionToolbar";
    public static final String CREATE_ACTION_POPUP_MENU_METHOD_NAME = "createActionPopupMenu";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                UExpression parameter;
                String methodName;
                PsiMethod method;
                if (UastExpressionUtils.isMethodCall((UElement)node) && (method = node.resolve()) != null && (methodName = node.getMethodName()) != null && UnspecifiedActionsPlaceInspection.requiresSpecifiedActionPlace(method, methodName) && node.getValueArgumentCount() > 0 && (parameter = node.getArgumentForParameter(0)) != null && UnspecifiedActionsPlaceInspection.actionPlaceIsUnspecified(parameter)) {
                    PsiElement reportedElement = parameter.getSourcePsi();
                    if (reportedElement == null) {
                        return true;
                    }
                    String messageKey = UnspecifiedActionsPlaceInspection.CREATE_ACTION_TOOLBAR_METHOD_NAME.equals(methodName) ? "inspections.unspecified.actions.place.toolbar" : "inspections.unspecified.actions.place.popup.menu";
                    holder.registerProblem(reportedElement, DevKitBundle.message(messageKey, new Object[0]), new LocalQuickFix[0]);
                }
                return true;
            }
        }, (Class[])HINTS);
    }

    private static boolean requiresSpecifiedActionPlace(@NotNull PsiMethod method, @NotNull String methodName) {
        PsiType type;
        PsiParameter[] parameters;
        PsiClass aClass;
        return (CREATE_ACTION_TOOLBAR_METHOD_NAME.equals(methodName) || CREATE_ACTION_POPUP_MENU_METHOD_NAME.equals(methodName)) && (aClass = method.getContainingClass()) != null && ActionManager.class.getName().equals(aClass.getQualifiedName()) && (parameters = method.getParameterList().getParameters()).length > 0 && parameters[0].getType() instanceof PsiClassType && Objects.equals(((PsiClassType)(type = parameters[0].getType())).getClassName(), "String") && "java.lang.String".equals(type.getCanonicalText(false));
    }

    private static boolean actionPlaceIsUnspecified(UExpression parameter) {
        String stringValue;
        Object evaluatedExpression = parameter.evaluate();
        return evaluatedExpression instanceof String && ((stringValue = (String)evaluatedExpression).isEmpty() || "unknown".equals(stringValue));
    }

    @NotNull
    public String getShortName() {
        return "UnspecifiedActionsPlace";
    }
}

