/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.references.PluginConfigReference;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public class UnresolvedPluginConfigReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !PsiUtil.isPluginModule(module)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                UInjectionHost expression = (UInjectionHost)UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
                if (expression == null) {
                    return;
                }
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PluginConfigReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference);
                }
            }
        };
    }
}

