/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "AddDescriptionKeyIntention", "Companion", "ShowEPDeclarationIntention", "intellij.devkit.core"})
public final class RegistryPropertiesAnnotator
implements Annotator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    private static final Set<String> PLUGIN_GROUP_NAMES;
    @NonNls
    @NotNull
    private static final String REGISTRY_PROPERTIES_FILENAME = "registry.properties";
    @NonNls
    @NotNull
    public static final String DESCRIPTION_SUFFIX = ".description";
    @NonNls
    @NotNull
    public static final String RESTART_REQUIRED_SUFFIX = ".restartRequired";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (!(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!Companion.isRegistryPropertiesFile(file)) {
            return;
        }
        String propertyName = ((PropertyKeyImpl)element).getText();
        if (Companion.isImplicitUsageKey(propertyName)) {
            return;
        }
        String string = StringsKt.substringBefore$default((String)propertyName, (char)'.', null, (int)2, null).toLowerCase(Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        String groupName = string;
        if (PLUGIN_GROUP_NAMES.contains(groupName) || StringsKt.startsWith$default((String)propertyName, (String)"editor.config.", (boolean)false, (int)2, null)) {
            holder.newAnnotation(HighlightSeverity.ERROR, DevKitBundle.message("registry.properties.annotator.plugin.keys.use.ep", new Object[0])).withFix((IntentionAction)new ShowEPDeclarationIntention(propertyName)).create();
        }
        Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
        PropertiesFile propertiesFile = (PropertiesFile)file;
        IProperty descriptionProperty = propertiesFile.findPropertyByKey(propertyName + DESCRIPTION_SUFFIX);
        if (descriptionProperty == null) {
            Object[] objectArray = new Object[]{propertyName};
            holder.newAnnotation(HighlightSeverity.WARNING, DevKitBundle.message("registry.properties.annotator.key.no.description.key", objectArray)).withFix((IntentionAction)new AddDescriptionKeyIntention(propertyName)).create();
        }
    }

    @JvmStatic
    public static final boolean isImplicitUsageKey(@NotNull String keyName) {
        return Companion.isImplicitUsageKey(keyName);
    }

    @JvmStatic
    public static final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
        return Companion.isRegistryPropertiesFile(psiFile);
    }

    static {
        Object[] objectArray = new String[]{"appcode", "cidr", "clion", "cvs", "git", "github", "svn", "hg4idea", "tfs", "dart", "markdown", "java", "javac", "uast", "junit4", "dsm", "js", "javascript", "typescript", "nodejs", "eslint", "jest", "ruby", "rubymine", "groovy", "grails", "python", "php", "kotlin"};
        PLUGIN_GROUP_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$ShowEPDeclarationIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "propertyName", "", "(Ljava/lang/String;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "isAvailable", "", "startInWriteAction", "intellij.devkit.core"})
    private static final class ShowEPDeclarationIntention
    implements IntentionAction {
        @NotNull
        private final String propertyName;

        public ShowEPDeclarationIntention(@NotNull String propertyName) {
            this.propertyName = propertyName;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            return IntentionPreviewInfo.EMPTY;
        }

        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("registry.properties.annotator.show.ep.family.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            return true;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.propertyName};
            return DevKitBundle.message("registry.properties.annotator.show.ep.name", objectArray);
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            IProperty iProperty = propertiesFile.findPropertyByKey(this.propertyName);
            Intrinsics.checkNotNull((Object)iProperty);
            String defaultValue = iProperty.getValue();
            IProperty iProperty2 = propertiesFile.findPropertyByKey(this.propertyName + RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX);
            String description2 = iProperty2 != null ? iProperty2.getValue() : null;
            String restartRequiredText = "";
            if (propertiesFile.findPropertyByKey(this.propertyName + RegistryPropertiesAnnotator.RESTART_REQUIRED_SUFFIX) != null) {
                restartRequiredText = "restartRequired=\"true\"";
            }
            String epText = StringsKt.trimIndent((String)("\n        <registryKey key=\"" + this.propertyName + "\" defaultValue=\"" + defaultValue + "\" " + restartRequiredText + "\n                     description=\"" + description2 + "\"/>\n      "));
            Messages.showMultilineInputDialog((Project)project, (String)DevKitBundle.message("registry.properties.annotator.show.ep.message", new Object[0]), (String)DevKitBundle.message("registry.properties.annotator.show.ep.title", new Object[0]), (String)epText, null, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$AddDescriptionKeyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "myPropertyName", "", "(Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.devkit.core"})
    private static final class AddDescriptionKeyIntention
    implements IntentionAction {
        @NotNull
        private final String myPropertyName;

        public AddDescriptionKeyIntention(@NotNull String myPropertyName) {
            this.myPropertyName = myPropertyName;
        }

        @Nls
        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.myPropertyName};
            return DevKitBundle.message("registry.properties.annotator.add.description.text", objectArray);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("registry.properties.annotator.add.description.family.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.PropertiesFile");
            PropertiesFile propertiesFile = (PropertiesFile)file;
            PropertyImpl originalProperty = (PropertyImpl)propertiesFile.findPropertyByKey(this.myPropertyName);
            IProperty descriptionProperty = propertiesFile.addPropertyAfter(this.myPropertyName + RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX, "Description", (IProperty)originalProperty);
            PsiElement psiElement = descriptionProperty.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
            ASTNode aSTNode = ((PropertyImpl)psiElement).getValueNode();
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode valueNode = aSTNode;
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)valueNode.getPsi())) {
                PsiNavigateUtil.navigate((PsiElement)valueNode.getPsi());
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/RegistryPropertiesAnnotator$Companion;", "", "()V", "DESCRIPTION_SUFFIX", "", "PLUGIN_GROUP_NAMES", "", "REGISTRY_PROPERTIES_FILENAME", "RESTART_REQUIRED_SUFFIX", "isImplicitUsageKey", "", "keyName", "isRegistryPropertiesFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.devkit.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isImplicitUsageKey(@NotNull String keyName) {
            return StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.DESCRIPTION_SUFFIX) || StringUtil.endsWith((CharSequence)keyName, (CharSequence)RegistryPropertiesAnnotator.RESTART_REQUIRED_SUFFIX);
        }

        @JvmStatic
        public final boolean isRegistryPropertiesFile(@NotNull PsiFile psiFile) {
            return PsiUtil.isIdeaProject(psiFile.getProject()) && Intrinsics.areEqual((Object)psiFile.getName(), (Object)RegistryPropertiesAnnotator.REGISTRY_PROPERTIES_FILENAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

