/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementOrExtendFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

public class RegistrationProblemsInspection
extends DevKitUastInspectionBase {
    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        RegistrationCheckerUtil.RegistrationType registrationType;
        Set<PsiClass> componentClasses;
        PsiClass checkedClass = uClass.getJavaPsi();
        PsiIdentifier nameIdentifier = checkedClass.getNameIdentifier();
        if (!(nameIdentifier == null || checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.isInterface() || checkedClass.isEnum() || checkedClass.hasModifierProperty("private") || checkedClass.hasModifierProperty("protected") || PsiUtil.isInnerClass((PsiClass)checkedClass) || (componentClasses = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, registrationType = RegistrationCheckerUtil.RegistrationType.ALL)) == null || componentClasses.isEmpty())) {
            PsiElement sourcePsi = uClass.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            UElement classAnchor = uClass.getUastAnchor();
            if (classAnchor == null) {
                return null;
            }
            PsiElement classPsiAnchor = classAnchor.getSourcePsi();
            if (classPsiAnchor == null) {
                return null;
            }
            ProblemsHolder holder = RegistrationProblemsInspection.createProblemsHolder((UElement)uClass, manager, isOnTheFly);
            for (PsiClass componentClass : componentClasses) {
                if (!ActionType.ACTION.myClassName.equals(componentClass.getQualifiedName()) || checkedClass.isInheritor(componentClass, true)) continue;
                LocalQuickFix[] fixes = sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE) ? ImplementOrExtendFix.createFixes((PsiElement)nameIdentifier, (PsiClass)checkedClass, (PsiClass)componentClass, (boolean)isOnTheFly) : LocalQuickFix.EMPTY_ARRAY;
                holder.registerProblem(classPsiAnchor, DevKitBundle.message("inspections.registration.problems.incompatible.message", componentClass.getQualifiedName()), fixes);
            }
            if (ActionType.ACTION.isOfType(checkedClass) && !RegistrationProblemsInspection.hasNoArgConstructor(checkedClass)) {
                LocalQuickFix[] localQuickFixArray;
                if (sourcePsi.getLanguage().is((Language)JavaLanguage.INSTANCE)) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new CreateConstructorFix(checkedClass, isOnTheFly);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                holder.registerProblem(classPsiAnchor, DevKitBundle.message("inspections.registration.problems.missing.noarg.ctor", new Object[0]), fixes);
            }
            if (checkedClass.hasModifierProperty("abstract")) {
                holder.registerProblem(classPsiAnchor, DevKitBundle.message("inspections.registration.problems.abstract", new Object[0]), new LocalQuickFix[0]);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private static boolean hasNoArgConstructor(PsiClass checkedClass) {
        PsiMethod[] constructors = checkedClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor2 : constructors) {
            if (!constructor2.getParameterList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "ComponentRegistrationProblems";
    }

    private static class CreateConstructorFix
    implements LocalQuickFix {
        protected final SmartPsiElementPointer<? extends PsiElement> myPointer;
        protected final boolean myOnTheFly;

        CreateConstructorFix(@NotNull PsiClass aClass, boolean isOnTheFly) {
            this.myPointer = SmartPointerManager.createPointer((PsiElement)aClass);
            this.myOnTheFly = isOnTheFly;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            return IntentionPreviewInfo.EMPTY;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass clazz;
            boolean external;
            PsiElement element = this.myPointer.getElement();
            if (element == null || !element.isValid()) {
                return;
            }
            boolean bl = external = descriptor.getPsiElement().getContainingFile() != element.getContainingFile();
            if (external) {
                clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
                if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{element.getContainingFile().getVirtualFile()})) {
                    String className = clazz != null ? clazz.getQualifiedName() : element.getContainingFile().getName();
                    Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("inspections.registration.problems.quickfix.read-only", className), (String)CommonBundle.getErrorTitle());
                    return;
                }
            }
            try {
                if (!(element instanceof PsiClass)) {
                    return;
                }
                clazz = (PsiClass)element;
                PsiMethod ctor = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory().createConstructor();
                PsiUtil.setModifierProperty((PsiModifierListOwner)ctor, (String)"public", (boolean)true);
                PsiMethod[] constructors = clazz.getConstructors();
                ctor = constructors.length > 0 ? (PsiMethod)clazz.addBefore((PsiElement)ctor, (PsiElement)constructors[0]) : (PsiMethod)clazz.add((PsiElement)ctor);
                if (this.myOnTheFly) {
                    ctor.navigate(true);
                }
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(this.getClass()).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.registration.problems.quickfix.create.constructor", new Object[0]);
        }
    }
}

