/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

public class PsiElementConcatenationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                String methodName = call.getMethodExpression().getReferenceName();
                if (methodName == null || !methodName.startsWith("create")) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiExpression arg = args[0];
                PsiType argType = arg.getType();
                if (argType == null || !argType.equalsToText("java.lang.String")) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !PsiElementFactory.class.getName().equals(aClass.getQualifiedName())) {
                    return;
                }
                this.checkOperand(arg, new HashSet<PsiExpression>());
            }

            private void checkOperand(@Nullable PsiExpression operand, Set<PsiExpression> visited) {
                PsiPolyadicExpression polyadic;
                PsiClass aClass;
                PsiMethodCallExpression call;
                PsiMethod method;
                PsiCodeBlock block;
                PsiElement element;
                if (operand == null || !visited.add(operand)) {
                    return;
                }
                if (operand instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)operand).resolve()) instanceof PsiLocalVariable && ((PsiLocalVariable)element).getType().equalsToText("java.lang.String") && (block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class)) != null) {
                    PsiElement[] defs;
                    PsiElement[] psiElementArray = defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)((PsiVariable)element), (PsiElement)operand);
                    int n = psiElementArray.length;
                    for (int i = 0; i < n; ++i) {
                        PsiAssignmentExpression assignment;
                        PsiElement def = psiElementArray[i];
                        if (def instanceof PsiLocalVariable) {
                            this.checkOperand(((PsiLocalVariable)def).getInitializer(), visited);
                        }
                        if (def instanceof PsiReferenceExpression && (assignment = ExpressionUtils.getAssignment((PsiElement)def.getParent())) != null && assignment.getLExpression() == def) {
                            this.checkOperand(assignment.getRExpression(), visited);
                        }
                        if (!(def instanceof PsiExpression)) continue;
                        this.checkOperand((PsiExpression)def, visited);
                    }
                }
                if (operand instanceof PsiMethodCallExpression && MethodUtils.isToString((PsiMethod)(method = (call = (PsiMethodCallExpression)operand).resolveMethod()))) {
                    this.checkOperand(call.getMethodExpression().getQualifierExpression(), visited);
                }
                if (InheritanceUtil.isInheritor((PsiClass)(aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand.getType())), (boolean)false, (String)PsiElement.class.getName())) {
                    holder.registerProblem((PsiElement)operand, DevKitBundle.message("inspections.psi.element.concat.psi.element", new Object[0]), new LocalQuickFix[]{new AddGetTextFix("getText")});
                }
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)PsiType.class.getName())) {
                    holder.registerProblem((PsiElement)operand, DevKitBundle.message("inspections.psi.element.concat.psi.type", new Object[0]), new LocalQuickFix[]{new AddGetTextFix("getCanonicalText")});
                }
                if (operand instanceof PsiPolyadicExpression && JavaTokenType.PLUS.equals((polyadic = (PsiPolyadicExpression)operand).getOperationTokenType())) {
                    for (PsiExpression op : polyadic.getOperands()) {
                        this.checkOperand(op, visited);
                    }
                }
            }
        };
    }

    private static final class AddGetTextFix
    implements LocalQuickFix {
        private final String myMethodName;

        private AddGetTextFix(String name) {
            this.myMethodName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            return DevKitBundle.message("inspections.psi.element.concat.add.get.text.name", this.myMethodName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.psi.element.concat.add.get.text.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(ParenthesesUtils.getText((PsiExpression)expression, (int)2) + "." + this.myMethodName + "()", (PsiElement)expression);
            PsiElement parent = expression.getParent().getParent();
            if (parent instanceof PsiMethodCallExpression && MethodUtils.isToString((PsiMethod)((PsiMethodCallExpression)parent).resolveMethod())) {
                element = parent;
            }
            PsiElement result = element.replace((PsiElement)replacement);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }
    }
}

