/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastLiteralUtils;

public class PresentationAnnotationInspection
extends DevKitUastInspectionBase {
    public PresentationAnnotationInspection() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiReference[] references;
        UAnnotation annotation = aClass.findAnnotation(Presentation.class.getCanonicalName());
        if (annotation == null) {
            return null;
        }
        UExpression iconExpression = annotation.findDeclaredAttributeValue("icon");
        if (!(iconExpression instanceof ULiteralExpression)) {
            return null;
        }
        PsiLanguageInjectionHost iconExpressionPsi = UastLiteralUtils.getPsiLanguageInjectionHost((ULiteralExpression)((ULiteralExpression)iconExpression));
        if (iconExpressionPsi == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, iconExpressionPsi.getContainingFile(), isOnTheFly);
        for (PsiReference reference : references = iconExpressionPsi.getReferences()) {
            PsiElement resolve = reference.resolve();
            if (resolve == null) {
                holder.registerProblem(reference);
                continue;
            }
            assert (resolve instanceof PsiField);
            DeprecationInspectionBase.checkDeprecated((PsiModifierListOwner)((PsiField)resolve), (PsiElement)iconExpressionPsi, (TextRange)reference.getRangeInElement(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, (ProblemsHolder)holder, (boolean)false);
        }
        return holder.getResultsArray();
    }
}

