/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProviderBean;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceContributorEP;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingUtil;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

public class PluginXmlExtensionRegistrationInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (!(element instanceof Extension)) {
            return;
        }
        Extension extension = (Extension)element;
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null || !DomUtil.hasXml(extensionPoint.getBeanClass())) {
            return;
        }
        if (StubElementTypeHolderEP.class.getName().equals(extensionPoint.getBeanClass().getStringValue())) {
            if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(extension, "externalIdPrefix")) {
                holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.externalidprefix.attribute", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("externalIdPrefix")});
            }
            return;
        }
        if (ServiceDescriptor.class.getName().equals(extensionPoint.getBeanClass().getStringValue())) {
            GenericAttributeValue<?> serviceInterface = PluginXmlExtensionRegistrationInspection.getAttribute(extension, "serviceInterface");
            GenericAttributeValue<?> serviceImplementation = PluginXmlExtensionRegistrationInspection.getAttribute(extension, "serviceImplementation");
            if (serviceInterface != null && serviceImplementation != null && StringUtil.equals((CharSequence)serviceInterface.getStringValue(), (CharSequence)serviceImplementation.getStringValue()) && PluginXmlExtensionRegistrationInspection.hasMissingAttribute(extension, "testServiceImplementation")) {
                PluginXmlExtensionRegistrationInspection.highlightRedundant(serviceInterface, DevKitBundle.message("inspections.plugin.xml.service.interface.class.redundant", new Object[0]), ProblemHighlightType.WARNING, holder);
            }
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)InspectionEP.class.getName())) {
            if (!PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "key")) {
                if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "bundle")) {
                    PluginXmlExtensionRegistrationInspection.checkDefaultBundle(element, holder);
                }
            } else if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "displayName")) {
                PluginXmlExtensionRegistrationInspection.registerDefineAttributeProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.displayName.or.key", new Object[0]), "displayName", "key");
            }
            if (!PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupKey")) {
                if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "bundle") && PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupBundle")) {
                    PluginXmlExtensionRegistrationInspection.checkDefaultBundle(element, holder);
                }
            } else if (PluginXmlExtensionRegistrationInspection.hasMissingAttribute(element, "groupName")) {
                PluginXmlExtensionRegistrationInspection.registerDefineAttributeProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.groupName.or.groupKey", new Object[0]), "groupName", "groupKey");
            }
        }
        if (PluginXmlExtensionRegistrationInspection.isExtensionPointWithLanguage(extensionPoint)) {
            GenericDomValue<?> languageTag;
            DomAttributeChildDescription languageAttributeDescription = extension.getGenericInfo().getAttributeChildDescription("language");
            if (languageAttributeDescription != null) {
                if (!DomUtil.hasXml((DomElement)languageAttributeDescription.getDomAttributeValue((DomElement)extension))) {
                    holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.attribute", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[]{new DefineAttributeQuickFix("language", "", LanguageResolvingUtil.getAnyLanguageValue(extensionPoint))});
                }
                return;
            }
            DomFixedChildDescription languageTagDescription = extension.getGenericInfo().getFixedChildDescription("language");
            if (languageTagDescription != null && (languageTag = PluginXmlExtensionRegistrationInspection.getTag(extension, "language")) != null && !DomUtil.hasXml(languageTag)) {
                holder.createProblem((DomElement)extension, DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.tag", extensionPoint.getEffectiveQualifiedName()), new LocalQuickFix[]{new AddLanguageTagQuickFix(LanguageResolvingUtil.getAnyLanguageValue(extensionPoint))});
            }
        }
    }

    private static void checkDefaultBundle(DomElement element, DomElementAnnotationHolder holder) {
        IdeaPlugin plugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)element, IdeaPlugin.class, (boolean)true);
        if (plugin != null && !DomUtil.hasXml(plugin.getResourceBundle())) {
            holder.createProblem(element, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.bundle", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(plugin.getResourceBundle())});
        }
    }

    private static void registerDefineAttributeProblem(DomElement element, DomElementAnnotationHolder holder, @InspectionMessage String message, String ... attributeNames) {
        if (holder.isOnTheFly()) {
            holder.createProblem(element, message, (LocalQuickFix[])ContainerUtil.map((Object[])attributeNames, attributeName -> new DefineAttributeQuickFix(attributeName), (Object[])new LocalQuickFix[attributeNames.length]));
        } else {
            holder.createProblem(element, message, new LocalQuickFix[0]);
        }
    }

    private static boolean isExtensionPointWithLanguage(ExtensionPoint extensionPoint) {
        String extensionBeanClass = extensionPoint.getBeanClass().getStringValue();
        return PsiReferenceContributorEP.class.getName().equals(extensionBeanClass) || PsiReferenceProviderBean.class.getName().equals(extensionBeanClass) || IntentionActionBean.class.getName().equals(extensionBeanClass) || InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)LanguageExtensionPoint.class.getName());
    }

    private static class AddLanguageTagQuickFix
    implements LocalQuickFix {
        private final String myAnyLanguageID;

        private AddLanguageTagQuickFix(String anyLanguageId) {
            this.myAnyLanguageID = anyLanguageId;
        }

        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspection.plugin.xml.extension.registration.should.define.language.tag.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag languageTag;
            Extension fixExtension = (Extension)DomUtil.findDomElement((PsiElement)descriptor.getPsiElement(), Extension.class, (boolean)false);
            if (fixExtension == null) {
                return;
            }
            XmlTag xmlTag = fixExtension.getXmlTag();
            XmlTag addedLanguageTag = xmlTag.addSubTag(languageTag = xmlTag.createChildTag("language", null, this.myAnyLanguageID, false), true);
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)addedLanguageTag)) {
                PsiNavigationSupport.getInstance().createNavigatable(project, addedLanguageTag.getContainingFile().getVirtualFile(), addedLanguageTag.getValue().getTextRange().getEndOffset()).navigate(true);
            }
        }
    }
}

