/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.openapi.client.ClientKind;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getArea", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint$Area;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "intellij.devkit.core"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    public NonDefaultConstructorInspection() {
        Class[] classArray = new Class[]{UClass.class};
        super(classArray);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        block32: {
            block31: {
                javaPsi = aClass.getJavaPsi();
                if (Intrinsics.areEqual((Object)javaPsi.getLanguage().getID(), (Object)"Groovy") || javaPsi.getClassKind() != JvmClassKind.CLASS || PsiUtil.isInnerClass((PsiClass)javaPsi) || PsiUtil.isLocalOrAnonymousClass((PsiClass)javaPsi) || PsiUtil.isAbstractClass((PsiClass)javaPsi) || javaPsi.hasModifierProperty("private")) {
                    return null;
                }
                constructors = javaPsi.getConstructors();
                if (constructors.length == 0) {
                    return null;
                }
                area = null;
                isService = false;
                serviceClientKind = null;
                isServiceAnnotation = false;
                extensionPoint = null;
                if (!javaPsi.hasAnnotation("com.intellij.openapi.components.Service")) break block31;
                area = null;
                isService = true;
                isServiceAnnotation = true;
                break block32;
            }
            if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
                v0 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, manager.getProject());
                if (v0 == null) {
                    return null;
                }
                extensionPoint = v0;
            } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
                return null;
            }
            area = this.getArea((ExtensionPoint)extensionPoint);
            v1 = extensionPoint;
            isService = Intrinsics.areEqual((Object)(v1 != null && (v1 = v1.getBeanClass()) != null ? v1.getStringValue() : null), (Object)"com.intellij.openapi.components.ServiceDescriptor");
            if (!isService) break block32;
            for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(javaPsi)) {
                block37: {
                    block34: {
                        block36: {
                            block33: {
                                block35: {
                                    if ((XmlTag)candidate.pointer.getElement() == null || (v2 = extensionTag.getAttribute("client")) == null || (v2 = v2.getValue()) == null) continue;
                                    clientName = v2;
                                    Intrinsics.checkNotNullExpressionValue((Object)clientName.toLowerCase(Locale.US), (String)"this as java.lang.String).toLowerCase(locale)");
                                    switch (var16_21.hashCode()) {
                                        case 106164915: {
                                            if (!var16_21.equals("owner")) {
                                                ** break;
                                            }
                                            break block33;
                                        }
                                        case 96673: {
                                            if (!var16_21.equals("all")) {
                                                ** break;
                                            }
                                            break block34;
                                        }
                                        case 637428636: {
                                            if (var16_21.equals("controller")) break;
                                            ** break;
                                        }
                                        case 98708952: {
                                            if (!var16_21.equals("guest")) {
                                                ** break;
                                            }
                                            break block35;
                                        }
                                        case -934610874: {
                                            if (!var16_21.equals("remote")) {
                                                ** break;
                                            }
                                            break block36;
                                        }
                                        case 103145323: {
                                            if (!var16_21.equals("local")) ** break;
                                            v3 = ClientKind.LOCAL;
                                            break block37;
                                        }
                                    }
                                    v3 = ClientKind.CONTROLLER;
                                    break block37;
                                }
                                v3 = ClientKind.GUEST;
                                break block37;
                            }
                            v3 = ClientKind.OWNER;
                            break block37;
                        }
                        v3 = ClientKind.REMOTE;
                        break block37;
                    }
                    v3 = ClientKind.ALL;
                    break block37;
lbl72:
                    // 7 sources

                    v3 = kind = null;
                }
                if (serviceClientKind == null) {
                    serviceClientKind = kind;
                    continue;
                }
                if (serviceClientKind == kind) continue;
                serviceClientKind = ClientKind.ALL;
            }
        }
        isAppLevelExtensionPoint = area == null || area == ExtensionPoint.Area.IDEA_APPLICATION;
        errors = null;
        for (PsiMethod method : constructors) {
            block39: {
                block38: {
                    if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(method.getParameterList(), extensionPoint, isAppLevelExtensionPoint, serviceClientKind, isServiceAnnotation)) {
                        return null;
                    }
                    if (errors == null) {
                        errors = (List)new SmartList();
                    }
                    if (!method.isPhysical()) break block38;
                    v4 = method.getIdentifyingElement();
                    v5 = v4;
                    Intrinsics.checkNotNull((Object)v4);
                    break block39;
                }
                v5 = aClass.getSourcePsi();
                if (v5 == null) continue;
                it = v5;
                $i$a$-let-NonDefaultConstructorInspection$checkClass$anchorElement$1 = false;
                v6 = UastFacade.INSTANCE.findPlugin(it);
                if (v6 == null) ** GOTO lbl-1000
                $this$convertOpt$iv = v6;
                $i$f$convertOpt = false;
                if ((PsiElement)method == null) {
                    v7 = null;
                } else {
                    v8 = $this$convertOpt$iv.convertElement((PsiElement)method, (UElement)aClass, UMethod.class);
                    if (!(v8 instanceof UMethod)) {
                        v8 = null;
                    }
                    v7 = (UElement)((UMethod)v8);
                }
                if ((v6 = (UMethod)v7) != null) {
                    v9 = v6.getSourcePsi();
                } else lbl-1000:
                // 2 sources

                {
                    v9 = null;
                }
                v5 = v9;
                if (v9 == null) {
                    continue;
                }
            }
            anchorElement = v5;
            v10 = kind = isService != false ? DevKitBundle.message("inspections.non.default.warning.type.service", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.type.extension", new Object[0]);
            suffix = area == null ? DevKitBundle.message("inspections.non.default.warning.suffix.project.or.module", new Object[0]) : (isAppLevelExtensionPoint != false ? "" : (area == ExtensionPoint.Area.IDEA_PROJECT ? DevKitBundle.message("inspections.non.default.warning.suffix.project", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.suffix.module", new Object[0])));
            var19_24 = new Object[]{kind, suffix};
            errors.add(manager.createProblemDescriptor(anchorElement, DevKitBundle.message("inspections.non.default.warning.and.suffix.message", var19_24), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        v11 = errors;
        if (v11 != null) {
            $this$toTypedArray$iv = v11;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v12 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        } else {
            v12 = null;
        }
        return v12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExtensionPoint.Area getArea(ExtensionPoint extensionPoint) {
        ExtensionPoint extensionPoint2 = extensionPoint;
        if (extensionPoint2 == null) {
            return ExtensionPoint.Area.IDEA_APPLICATION;
        }
        String areaName = extensionPoint2.getArea().getStringValue();
        String string = areaName;
        if (Intrinsics.areEqual((Object)string, (Object)"IDEA_PROJECT")) {
            return ExtensionPoint.Area.IDEA_PROJECT;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"IDEA_MODULE")) {
            return ExtensionPoint.Area.IDEA_MODULE;
        }
        String string2 = (String)extensionPoint.getName().getValue();
        if (string2 == null) return ExtensionPoint.Area.IDEA_APPLICATION;
        switch (string2.hashCode()) {
            case 350807721: {
                if (string2.equals("moduleService")) return ExtensionPoint.Area.IDEA_MODULE;
                return ExtensionPoint.Area.IDEA_APPLICATION;
            }
            case -1492183716: {
                if (!string2.equals("projectService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_PROJECT;
            }
        }
        return ExtensionPoint.Area.IDEA_APPLICATION;
    }
}

