/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/devkit/inspections/IncorrectParentDisposableInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "sdkLink", "", "buildInternalVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isAllowed", "intellij.devkit.core"})
public final class IncorrectParentDisposableInspection
extends DevKitUastInspectionBase {
    @NotNull
    private final String sdkLink;

    public IncorrectParentDisposableInspection() {
        Class[] classArray = new Class[]{UCallExpression.class};
        super(classArray);
        this.sdkLink = "https://plugins.jetbrains.com/docs/intellij/disposers.html?from=IncorrectParentDisposable#choosing-a-disposable-parent";
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        return DevKitInspectionUtil.isAllowedInPluginsOnly(holder.getFile());
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Class[] classArray = new Class[]{UCallExpression.class};
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ IncorrectParentDisposableInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                IncorrectParentDisposableInspection.access$checkCallExpression(this.this$0, node, this.$holder);
                return true;
            }
        }, (Class[])classArray, (boolean)false, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallExpression(UCallExpression node, ProblemsHolder holder) {
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        if (Intrinsics.areEqual((Object)psiMethod2.getName(), (Object)"isDisposed")) {
            return;
        }
        JvmParameter[] $this$forEachIndexed$iv = psiMethod2.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (JvmParameter item$iv : $this$forEachIndexed$iv) {
            PsiElement argumentSourcePsi;
            String typeName;
            PsiType psiType;
            PsiClassType psiClassType;
            UExpression argument;
            PsiClassType parameterType;
            void parameter;
            int n = index$iv++;
            JvmParameter jvmParameter = item$iv;
            int index = n;
            boolean bl = false;
            JvmType jvmType = parameter.getType();
            PsiClassType psiClassType2 = jvmType instanceof PsiClassType ? (PsiClassType)jvmType : null;
            if (psiClassType2 == null) continue;
            if ((psiClassType2 = psiClassType2.resolve()) == null || !Intrinsics.areEqual((Object)(parameterType = psiClassType2).getQualifiedName(), (Object)Disposable.class.getName()) || node.getArgumentForParameter(index) == null || argument.getSourcePsi() == null || (psiClassType = (psiType = argument.getExpressionType()) instanceof PsiClassType ? (PsiClassType)psiType : null) == null || (psiClassType = psiClassType.resolve()) == null) continue;
            PsiClassType argumentType = psiClassType;
            Project project = argumentType.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            String string = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Project.class.getName(), psiMethod2.getResolveScope()), (boolean)true) ? "Project" : (InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Application.class.getName(), psiMethod2.getResolveScope()), (boolean)true) ? "Application" : (typeName = InheritanceUtil.isInheritorOrSelf((PsiClass)argumentType, (PsiClass)facade.findClass(Module.class.getName(), psiMethod2.getResolveScope()), (boolean)true) ? "Module" : null));
            if (typeName == null) continue;
            Object[] objectArray = new Object[]{typeName};
            holder.registerProblem(argumentSourcePsi, new HtmlBuilder().append(DevKitBundle.message("inspections.IncorrectParentDisposableInspection.do.not.use.as.disposable", objectArray)).nbsp().append("(").appendLink(this.sdkLink, DevKitBundle.message("inspections.IncorrectParentDisposableInspection.documentation.link.title", new Object[0])).append(")").wrapWith(HtmlChunk.html()).toString(), new LocalQuickFix[0]);
        }
    }

    public static final /* synthetic */ void access$checkCallExpression(IncorrectParentDisposableInspection $this, UCallExpression node, ProblemsHolder holder) {
        $this.checkCallExpression(node, holder);
    }
}

