/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;

public abstract class DevKitPluginXmlInspectionBase
extends BasicDomElementsInspection<IdeaPlugin> {
    protected DevKitPluginXmlInspectionBase() {
        super(IdeaPlugin.class, new Class[0]);
    }

    protected static boolean hasMissingAttribute(DomElement element, @NonNls String attributeName) {
        GenericAttributeValue<?> attribute = DevKitPluginXmlInspectionBase.getAttribute(element, attributeName);
        return attribute != null && !DomUtil.hasXml(attribute);
    }

    @Nullable
    protected static GenericAttributeValue<?> getAttribute(DomElement domElement, @NonNls String attributeName) {
        DomAttributeChildDescription attributeDescription = domElement.getGenericInfo().getAttributeChildDescription(attributeName);
        if (attributeDescription == null) {
            return null;
        }
        return attributeDescription.getDomAttributeValue(domElement);
    }

    @Nullable
    protected static GenericDomValue<?> getTag(DomElement domElement, @NonNls String tagName) {
        DomFixedChildDescription fixedChildDescription = domElement.getGenericInfo().getFixedChildDescription(tagName);
        if (fixedChildDescription == null) {
            return null;
        }
        DomElement domValueElement = (DomElement)ContainerUtil.getFirstItem((List)fixedChildDescription.getValues(domElement));
        return (GenericDomValue)ObjectUtils.tryCast((Object)domValueElement, GenericDomValue.class);
    }

    protected static void highlightRedundant(DomElement element, @InspectionMessage String message, ProblemHighlightType highlightType, DomElementAnnotationHolder holder) {
        holder.createProblem(element, highlightType, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)}).highlightWholeElement();
    }
}

