/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

public class ActionIsNotPreviewFriendlyInspection
extends DevKitUastInspectionBase {
    private static final String[] METHODS_TO_IGNORE_CLASS = new String[]{"generatePreview", "getFileModifierForPreview", "applyFixForPreview", "startInWriteAction", "invokeForPreview"};
    private static final Set<String> ALLOWED_METHOD_LOCATIONS = Set.of(LocalQuickFix.class.getName(), FileModifier.class.getName(), LocalQuickFixOnPsiElement.class.getName(), WriteActionAware.class.getName(), IntentionAction.class.getName());
    private static final Set<String> ALLOWED_FIELD_TYPES = Set.of(String.class.getName(), Class.class.getName(), Integer.class.getName(), Boolean.class.getName(), Long.class.getName(), Byte.class.getName(), Short.class.getName(), Float.class.getName(), Double.class.getName(), Character.class.getName());

    public ActionIsNotPreviewFriendlyInspection() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass node, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi = node.getSourcePsi();
        if (sourcePsi == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass psiClass = node.getJavaPsi();
        if (psiClass.isInterface()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)LocalQuickFix.class.getName()) && !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)IntentionAction.class.getName())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (ActionIsNotPreviewFriendlyInspection.hasCustomPreviewStrategy(psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        for (PsiField field : psiClass.getFields()) {
            PsiElement psiAnchor;
            boolean hasSafeFieldAnnotation;
            if (field.hasModifierProperty("static")) continue;
            boolean safeType = ActionIsNotPreviewFriendlyInspection.hasSafeType(field);
            PsiAnnotation annotation = field.getAnnotation(FileModifier.SafeFieldForPreview.class.getCanonicalName());
            boolean bl = hasSafeFieldAnnotation = annotation != null;
            if (hasSafeFieldAnnotation != safeType || (psiAnchor = ActionIsNotPreviewFriendlyInspection.getAnchor(field)) == null) continue;
            if (safeType) {
                PsiElement anchor = ActionIsNotPreviewFriendlyInspection.getAnchor(annotation);
                if (anchor == null) continue;
                holder.registerProblem(anchor, DevKitBundle.message("inspection.message.unnecessary.safe.field.annotation", new Object[0]), new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, (PsiModifierListOwner)field)});
                continue;
            }
            holder.registerProblem(psiAnchor, DevKitBundle.message("inspection.message.field.may.prevent.intention.preview.to.work.properly", new Object[0]), new LocalQuickFix[]{new AddAnnotationFix(FileModifier.SafeFieldForPreview.class.getCanonicalName(), (PsiModifierListOwner)field, new String[0])});
        }
        return holder.getResultsArray();
    }

    @Nullable
    private static PsiElement getAnchor(PsiField field) {
        UField uField = (UField)UastContextKt.toUElement((PsiElement)field, UField.class);
        if (uField == null) {
            return null;
        }
        UElement anchor = uField.getUastAnchor();
        if (anchor == null) {
            return null;
        }
        return anchor.getSourcePsi();
    }

    @Nullable
    private static PsiElement getAnchor(PsiAnnotation field) {
        UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)field, UAnnotation.class);
        if (uAnnotation == null) {
            return null;
        }
        return uAnnotation.getSourcePsi();
    }

    private static boolean hasSafeType(PsiField field) {
        PsiType type = field.getType().getDeepComponentType();
        if (type instanceof PsiPrimitiveType) {
            return true;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass fieldClass = ((PsiClassType)type).resolve();
        if (fieldClass == null) {
            return true;
        }
        if (fieldClass.isEnum()) {
            return true;
        }
        if (fieldClass.hasAnnotation(FileModifier.SafeTypeForPreview.class.getCanonicalName())) {
            return true;
        }
        String name = fieldClass.getQualifiedName();
        return name != null && ALLOWED_FIELD_TYPES.contains(name);
    }

    private static boolean hasCustomPreviewStrategy(PsiClass psiClass) {
        for (String methodName : METHODS_TO_IGNORE_CLASS) {
            for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
                boolean standardPreviewMethod;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) continue;
                String className = containingClass.getQualifiedName();
                boolean bl = standardPreviewMethod = className != null && ALLOWED_METHOD_LOCATIONS.contains(className) || method.getName().equals("startInWriteAction") && ActionIsNotPreviewFriendlyInspection.returnsTrue(method);
                if (standardPreviewMethod) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean returnsTrue(PsiMethod method) {
        Predicate<PsiMethod> predicate = m -> {
            PsiCodeBlock body = m.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1 || !(statements[0] instanceof PsiReturnStatement)) {
                return false;
            }
            PsiExpression value = ((PsiReturnStatement)statements[0]).getReturnValue();
            return BoolUtils.isTrue((PsiExpression)value);
        };
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)predicate.test(method), (Object[])new Object[]{method}));
    }
}

