/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.text.ChoiceFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.i18n.DevKitI18nBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/devkit/i18n/DevKitPropertiesQuotesValidationInspection;", "Lcom/intellij/lang/properties/PropertiesInspectionBase;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkQuotedParam", "", "pattern", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.devkit.i18n"})
public final class DevKitPropertiesQuotesValidationInspection
extends PropertiesInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!DevKitInspectionUtil.isAllowed(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ DevKitPropertiesQuotesValidationInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof Property)) {
                    return;
                }
                String string = ((Property)element).getValue();
                if (string == null) {
                    return;
                }
                String value = string;
                Integer n = this.this$0.checkQuotedParam(value);
                if (n == null) {
                    return;
                }
                int quotedParam = n;
                String paramString = "{" + quotedParam + "}";
                int n2 = StringsKt.indexOf$default((CharSequence)value, (String)paramString, (int)0, (boolean)false, (int)6, null);
                ASTNode aSTNode = element.getNode().findChildByType(PropertiesTokenTypes.VALUE_CHARACTERS);
                Intrinsics.checkNotNull((Object)aSTNode);
                int idx = n2 + aSTNode.getStartOffsetInParent();
                Object[] objectArray = new Object[]{paramString};
                this.$holder.registerProblem(element, new TextRange(idx, idx + paramString.length()), DevKitI18nBundle.message("inspection.message.wrong.quotes.around.parameter.reference", objectArray), new LocalQuickFix[0]);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer checkQuotedParam(@NotNull String pattern) {
        boolean raw = true;
        boolean inQuote = false;
        StringBuilder paramSB = null;
        int level = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            int n;
            char ch = pattern.charAt(i);
            if (raw) {
                if (ch == '\'') {
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    if (!inQuote) {
                        paramSB = new StringBuilder();
                    } else {
                        String quotedStr = String.valueOf(paramSB);
                        if (StringsKt.startsWith$default((CharSequence)quotedStr, (char)'{', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)quotedStr, (char)'}', (boolean)false, (int)2, null)) {
                            try {
                                CharSequence charSequence;
                                block26: {
                                    void $this$trimEnd$iv;
                                    CharSequence charSequence2;
                                    char it;
                                    int index$iv$iv;
                                    String $this$trimStart$iv;
                                    block25: {
                                        $this$trimStart$iv = quotedStr;
                                        boolean $i$f$trimStart = false;
                                        CharSequence $this$trimStart$iv$iv = $this$trimStart$iv;
                                        boolean $i$f$trimStart2 = false;
                                        n = $this$trimStart$iv$iv.length();
                                        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                            it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                                            boolean bl = false;
                                            if (it == '{') continue;
                                            charSequence2 = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                                            break block25;
                                        }
                                        charSequence2 = "";
                                    }
                                    $this$trimStart$iv = ((Object)charSequence2).toString();
                                    boolean $i$f$trimEnd = false;
                                    CharSequence $this$trimEnd$iv$iv = (CharSequence)$this$trimEnd$iv;
                                    boolean $i$f$trimEnd2 = false;
                                    index$iv$iv = $this$trimEnd$iv$iv.length() + -1;
                                    if (0 <= index$iv$iv) {
                                        do {
                                            int index$iv$iv2 = index$iv$iv--;
                                            it = $this$trimEnd$iv$iv.charAt(index$iv$iv2);
                                            boolean bl = false;
                                            if (it == '}') continue;
                                            charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv2 + 1);
                                            break block26;
                                        } while (0 <= index$iv$iv);
                                    }
                                    charSequence = "";
                                }
                                return Integer.parseInt(((Object)charSequence).toString());
                            }
                            catch (NumberFormatException $this$trimEnd$iv) {
                                // empty catch block
                            }
                        }
                        paramSB = null;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    raw = false;
                    continue;
                }
                if (!inQuote) continue;
                StringBuilder stringBuilder = paramSB;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(ch);
                continue;
            }
            StringBuilder stringBuilder = paramSB;
            if (stringBuilder != null) {
                stringBuilder.append(ch);
            }
            if (inQuote) {
                if (ch == '\'') {
                    inQuote = false;
                }
                continue;
            }
            char c = ch;
            if (c == '{') {
                ++level;
                continue;
            }
            if (c == ',') {
                String prefix = "choice,";
                String string = pattern.substring(i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)prefix, (boolean)false, (int)2, null)) {
                    i += prefix.length() + 1;
                    paramSB = new StringBuilder();
                }
                continue;
            }
            if (c == '}') {
                if (level-- != 0) continue;
                try {
                    CharSequence charSequence;
                    block27: {
                        String $this$trimEnd$iv = String.valueOf(paramSB);
                        boolean $i$f$trimEnd = false;
                        CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                        boolean $i$f$trimEnd3 = false;
                        n = $this$trimEnd$iv$iv.length() + -1;
                        if (0 <= n) {
                            do {
                                int index$iv$iv = n--;
                                char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                if (it == '}') continue;
                                charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                                break block27;
                            } while (0 <= n);
                        }
                        charSequence = "";
                    }
                    String string = ((Object)charSequence).toString();
                    ChoiceFormat choiceFormat = new ChoiceFormat(string);
                    for (Object format : choiceFormat.getFormats()) {
                        Intrinsics.checkNotNull((Object)format, (String)"null cannot be cast to non-null type kotlin.String");
                        Integer n2 = this.checkQuotedParam((String)format);
                        if (n2 == null) continue;
                        return n2;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                paramSB = null;
                raw = true;
                continue;
            }
            if (c != '\'') continue;
            inQuote = true;
        }
        return null;
    }
}

