/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.groovy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.internal.GoodCodeRedVisitor;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrAccessibilityChecker;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitorBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyGoodCodeRedVisitor
implements GoodCodeRedVisitor {
    @Override
    @NotNull
    public PsiElementVisitor createVisitor(final ProblemsHolder holder) {
        if (!Registry.is((String)"groovy.good.code.is.red", (boolean)false)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        GroovyFileBase file = (GroovyFileBase)holder.getFile();
        Project project = holder.getProject();
        GrAccessibilityChecker accessibilityChecker = new GrAccessibilityChecker(file, project);
        GroovyStaticTypeCheckVisitorBase typeCheckVisitor = new GroovyStaticTypeCheckVisitorBase(){

            protected void registerError(@NotNull PsiElement location, @NotNull @InspectionMessage String description2, LocalQuickFix @Nullable [] fixes, @NotNull ProblemHighlightType highlightType) {
                if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
                    holder.registerProblem(location, description2, new LocalQuickFix[0]);
                }
            }
        };
        return new GroovyPsiElementVisitor(new GroovyElementVisitor((GroovyElementVisitor)typeCheckVisitor, accessibilityChecker, holder){
            final /* synthetic */ GroovyElementVisitor val$typeCheckVisitor;
            final /* synthetic */ GrAccessibilityChecker val$accessibilityChecker;
            final /* synthetic */ ProblemsHolder val$holder;
            {
                this.val$typeCheckVisitor = groovyElementVisitor;
                this.val$accessibilityChecker = grAccessibilityChecker;
                this.val$holder = problemsHolder;
            }

            public void visitElement(@NotNull GroovyPsiElement element) {
                super.visitElement(element);
                element.accept(this.val$typeCheckVisitor);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                HighlightInfo info = this.val$accessibilityChecker.checkReferenceExpression(referenceExpression);
                if (info != null) {
                    this.registerProblem(this.val$holder, info, (PsiElement)referenceExpression);
                }
            }

            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                super.visitCodeReferenceElement(refElement);
                HighlightInfo info = this.val$accessibilityChecker.checkCodeReferenceElement(refElement);
                if (info != null) {
                    this.registerProblem(this.val$holder, info, (PsiElement)refElement);
                }
            }

            private void registerProblem(ProblemsHolder holder, HighlightInfo info, PsiElement e) {
                if (info.getSeverity() == HighlightSeverity.ERROR) {
                    holder.registerProblem(e, info.getDescription(), new LocalQuickFix[0]);
                }
            }
        });
    }
}

