/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;
import org.jetbrains.idea.devkit.dom.index.RegistrationIndexer;

public class IdeaPluginRegistrationIndex
extends PluginXmlIndexBase<String, List<RegistrationEntry>> {
    private static final int INDEX_VERSION = 8;
    private static final ID<String, List<RegistrationEntry>> NAME = ID.create((String)"IdeaPluginRegistrationIndex");
    private final DataExternalizer<List<RegistrationEntry>> myValueExternalizer = new DataExternalizer<List<RegistrationEntry>>(){

        public void save(@NotNull DataOutput out, List<RegistrationEntry> values) throws IOException {
            DataInputOutputUtilRt.writeSeq((DataOutput)out, values, entry -> {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getRegistrationType().ordinal());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getOffset());
            });
        }

        public List<RegistrationEntry> read(@NotNull DataInput in) throws IOException {
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                RegistrationEntry.RegistrationType type = RegistrationEntry.RegistrationType.values()[DataInputOutputUtil.readINT((DataInput)in)];
                int offset = DataInputOutputUtil.readINT((DataInput)in);
                return new RegistrationEntry(type, offset);
            });
        }
    };

    @NotNull
    public ID<String, List<RegistrationEntry>> getName() {
        return NAME;
    }

    @Override
    protected Map<String, List<RegistrationEntry>> performIndexing(IdeaPlugin plugin) {
        return new RegistrationIndexer(plugin).indexFile();
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<List<RegistrationEntry>> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    public int getVersion() {
        return 8;
    }

    public static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, null);
    }

    public static boolean isRegisteredComponentInterface(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE);
    }

    public static boolean isRegisteredApplicationComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
    }

    public static boolean isRegisteredProjectComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
    }

    public static boolean isRegisteredModuleComponent(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    public static boolean isRegisteredActionOrGroup(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.ACTION);
    }

    public static boolean isRegisteredListenerTopic(PsiClass psiClass, GlobalSearchScope scope) {
        return IdeaPluginRegistrationIndex.isRegisteredClass(psiClass, scope, RegistrationEntry.RegistrationType.LISTENER_TOPIC);
    }

    public static boolean processComponent(Project project, PsiClass componentInterfaceOrImplementationClass, GlobalSearchScope scope, Processor<? super Component> processor) {
        String key = componentInterfaceOrImplementationClass.getQualifiedName();
        assert (key != null) : componentInterfaceOrImplementationClass;
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_COMPONENT, RegistrationEntry.RegistrationType.PROJECT_COMPONENT, RegistrationEntry.RegistrationType.MODULE_COMPONENT, RegistrationEntry.RegistrationType.COMPONENT_INTERFACE), Component.class, true, processor);
    }

    public static boolean processListener(@NotNull Project project, PsiClass listenerClass, GlobalSearchScope scope, Processor<? super Listeners.Listener> processor) {
        return IdeaPluginRegistrationIndex.doProcessListener(project, listenerClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.APPLICATION_LISTENER, RegistrationEntry.RegistrationType.PROJECT_LISTENER), processor);
    }

    public static boolean processListenerTopic(@NotNull Project project, PsiClass topicClass, GlobalSearchScope scope, Processor<? super Listeners.Listener> processor) {
        return IdeaPluginRegistrationIndex.doProcessListener(project, topicClass, scope, EnumSet.of(RegistrationEntry.RegistrationType.LISTENER_TOPIC), processor);
    }

    private static boolean doProcessListener(@NotNull Project project, PsiClass psiClass, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<? super Listeners.Listener> processor) {
        String key = psiClass.getQualifiedName();
        assert (key != null) : psiClass;
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, types, Listeners.Listener.class, true, processor);
    }

    private static boolean isRegisteredClass(PsiClass psiClass, GlobalSearchScope scope, @Nullable RegistrationEntry.RegistrationType type) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        return !FileBasedIndex.getInstance().processValues(NAME, (Object)qualifiedName, null, (file, value) -> ContainerUtil.process((List)value, entry -> {
            RegistrationEntry.RegistrationType registrationType = entry.getRegistrationType();
            if (type == null) {
                return !registrationType.isClass();
            }
            return registrationType != type;
        }), scope);
    }

    public static boolean processAllActionOrGroup(@NotNull Project project, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        HashSet keys = new HashSet();
        FileBasedIndex.getInstance().processAllKeys(NAME, s -> keys.add(s), scope, null);
        return ContainerUtil.process(keys, s -> IdeaPluginRegistrationIndex.processActionOrGroup(project, s, scope, processor));
    }

    public static boolean processActionOrGroupClass(@NotNull Project project, PsiClass actionOrGroupClass, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        String fqn = actionOrGroupClass.getQualifiedName();
        assert (fqn != null) : actionOrGroupClass;
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, fqn, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION), processor);
    }

    public static boolean processActionOrGroup(@NotNull Project project, @NotNull String actionOrGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionOrGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID, RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    public static boolean processAction(@NotNull Project project, @NotNull String actionId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_ID), processor);
    }

    public static boolean processGroup(@NotNull Project project, @NotNull String actionGroupId, GlobalSearchScope scope, Processor<? super ActionOrGroup> processor) {
        return IdeaPluginRegistrationIndex.doProcessActionOrGroup(project, actionGroupId, scope, EnumSet.of(RegistrationEntry.RegistrationType.ACTION_GROUP_ID), processor);
    }

    private static boolean doProcessActionOrGroup(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Processor<? super ActionOrGroup> processor) {
        return IdeaPluginRegistrationIndex.processAll(project, key, scope, types, ActionOrGroup.class, false, processor);
    }

    private static <T extends DomElement> boolean processAll(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types, Class<T> domClazz, boolean useParentDom, Processor<? super T> processor) {
        List<XmlTag> tags = IdeaPluginRegistrationIndex.collectTags(project, key, scope, types);
        return ContainerUtil.process(tags, tag -> {
            DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
            DomElement t = useParentDom ? (DomElement)DomUtil.getParentOfType((DomElement)domElement, (Class)domClazz, (boolean)false) : (DomElement)ObjectUtils.tryCast((Object)domElement, (Class)domClazz);
            if (t == null) {
                return true;
            }
            return processor.process((Object)t);
        });
    }

    @NotNull
    private static List<XmlTag> collectTags(@NotNull Project project, @NotNull String key, GlobalSearchScope scope, EnumSet<RegistrationEntry.RegistrationType> types) {
        SmartList tags = new SmartList();
        FileBasedIndex.getInstance().processValues(NAME, (Object)key, null, (arg_0, arg_1) -> IdeaPluginRegistrationIndex.lambda$collectTags$5(types, project, (List)tags, arg_0, arg_1), scope);
        return tags;
    }

    private static /* synthetic */ boolean lambda$collectTags$5(EnumSet types, Project project, List tags, VirtualFile file, List value) {
        for (RegistrationEntry entry : value) {
            PsiFile psiFile;
            if (!types.contains((Object)entry.getRegistrationType()) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            PsiElement psiElement = psiFile.findElementAt(entry.getOffset());
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
            tags.add(xmlTag);
        }
        return true;
    }
}

