/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleDescriptorNameConverter
extends ResolvingConverter<IdeaPlugin> {
    @NonNls
    private static final String SUB_DESCRIPTOR_DELIMITER = "/";
    @NonNls
    private static final String SUB_DESCRIPTOR_FILENAME_DELIMITER = ".";
    private static final Key<Double> LOOKUP_PRIORITY = Key.create((String)"LOOKUP_PRIORITY");

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        String moduleName;
        String filePath;
        String value = StringUtil.notNullize((String)s);
        if (ModuleDescriptorNameConverter.isSubDescriptor(value)) {
            filePath = ModuleDescriptorNameConverter.getSubDescriptorFilePath(value);
            moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        } else {
            filePath = ModuleDescriptorNameConverter.getDescriptorFilePath(value);
            moduleName = value;
        }
        return DevKitBundle.message("plugin.xml.convert.module.descriptor.name", filePath, moduleName);
    }

    @Nullable
    public IdeaPlugin fromString(@Nullable String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        Module currentModule = context.getModule();
        if (currentModule == null) {
            return null;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)context.getProject());
        if (ModuleDescriptorNameConverter.isSubDescriptor(s)) {
            Module module = moduleManager.findModuleByName(ModuleDescriptorNameConverter.getSubDescriptorModuleName(s));
            if (module == null) {
                return null;
            }
            return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getSubDescriptorFilePath(s));
        }
        Module module = moduleManager.findModuleByName(s);
        if (module == null) {
            return null;
        }
        return ModuleDescriptorNameConverter.findDescriptorFile(module, ModuleDescriptorNameConverter.getDescriptorFilePath(module.getName()));
    }

    @Nullable
    public String toString(@Nullable IdeaPlugin plugin, ConvertContext context) {
        if (plugin == null) {
            return null;
        }
        return ModuleDescriptorNameConverter.getDisplayName(plugin);
    }

    @NotNull
    private static String getDisplayName(@NotNull IdeaPlugin plugin) {
        VirtualFile virtualFile;
        String fileName;
        Module module = Objects.requireNonNull(plugin.getModule());
        String moduleName = module.getName();
        if (moduleName.equals(fileName = (virtualFile = DomUtil.getFile((DomElement)plugin).getVirtualFile()).getNameWithoutExtension())) {
            return fileName;
        }
        return moduleName + SUB_DESCRIPTOR_DELIMITER + StringUtil.substringAfterLast((String)fileName, (String)SUB_DESCRIPTOR_FILENAME_DELIMITER);
    }

    @NotNull
    public LookupElement createLookupElement(IdeaPlugin plugin) {
        String displayName = ModuleDescriptorNameConverter.getDisplayName(plugin);
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)Objects.requireNonNull(this.getPsiElement(plugin)), (String)displayName).withIcon(ElementPresentationManager.getIconForClass(ContentDescriptor.ModuleDescriptor.class)).withBoldness(ModuleDescriptorNameConverter.isSubDescriptor(displayName)).withTypeText(plugin.getPackage().getStringValue());
        Double priority = (Double)plugin.getUserData(LOOKUP_PRIORITY);
        return priority != null ? PrioritizedLookupElement.withPriority((LookupElement)builder2, (double)priority) : builder2;
    }

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Module currentModule = context.getModule();
        if (currentModule == null) {
            return Collections.emptyList();
        }
        Project project = context.getProject();
        SmartList variants = new SmartList();
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)currentModule, dependencies);
        dependencies.remove(currentModule);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            boolean prioritize = module == currentModule || dependencies.contains(module);
            String moduleName = module.getName();
            ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)arg_0 -> ModuleDescriptorNameConverter.lambda$getVariants$2(project, prioritize, module, currentModule, (List)variants, moduleName, arg_0)));
        }
        return variants;
    }

    @Nullable
    private static IdeaPlugin findDescriptorFile(@NotNull Module module, @NotNull String filePath) {
        Ref ideaPlugin = Ref.create();
        ModuleDescriptorNameConverter.processModuleSourceRoots(module, (Processor<VirtualFile>)((Processor)root -> {
            VirtualFile candidate = root.findChild(filePath);
            if (candidate == null) {
                return true;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(candidate);
            if (DescriptorUtil.isPluginXml(psiFile)) {
                ideaPlugin.set((Object)DescriptorUtil.getIdeaPlugin((XmlFile)psiFile));
                return false;
            }
            return true;
        }));
        return (IdeaPlugin)ideaPlugin.get();
    }

    private static void processModuleSourceRoots(@NotNull Module module, Processor<VirtualFile> processor) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE)) {
            if (processor.process((Object)root)) continue;
            return;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
            if (processor.process((Object)root)) continue;
            return;
        }
    }

    @NotNull
    private static String getDescriptorFilePath(@NotNull String fileName) {
        return fileName + ".xml";
    }

    private static boolean isSubDescriptor(@NotNull String value) {
        return StringUtil.contains((CharSequence)value, (CharSequence)SUB_DESCRIPTOR_DELIMITER);
    }

    @NotNull
    private static String getSubDescriptorModuleName(@NotNull String value) {
        String moduleName = StringUtil.substringBefore((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (moduleName != null) : value;
        return moduleName;
    }

    @NotNull
    private static String getSubDescriptorFilePath(@NotNull String value) {
        String moduleName = ModuleDescriptorNameConverter.getSubDescriptorModuleName(value);
        String fileName = StringUtil.substringAfter((String)value, (String)SUB_DESCRIPTOR_DELIMITER);
        assert (fileName != null) : value;
        return ModuleDescriptorNameConverter.getDescriptorFilePath(moduleName + SUB_DESCRIPTOR_FILENAME_DELIMITER + fileName);
    }

    private static /* synthetic */ boolean lambda$getVariants$2(Project project, boolean prioritize, Module module, Module currentModule, List variants, String moduleName, VirtualFile root) {
        Collection<IdeaPlugin> plugins = DescriptorUtil.getPlugins(project, GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)root, (boolean)false));
        if (prioritize) {
            plugins.forEach(plugin -> plugin.putUserData(LOOKUP_PRIORITY, module == currentModule ? 200.0 : 100.0));
        }
        variants.addAll(ContainerUtil.filter(plugins, plugin -> DomUtil.getFile((DomElement)plugin).getName().startsWith(moduleName)));
        return true;
    }
}

