/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverterBase;
import org.jetbrains.idea.devkit.dom.index.PluginIdModuleIndex;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public final class IdeaPluginConverter
extends IdeaPluginConverterBase {
    private static final Condition<IdeaPlugin> NON_CORE_PLUGINS = plugin -> plugin.hasRealPluginId();

    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPluginsWithoutSelf(context);
        return ContainerUtil.filter(plugins, NON_CORE_PLUGINS);
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        HashSet<String> result = new HashSet<String>();
        for (IdeaPlugin ideaPlugin : IdeaPluginConverter.getAllPluginsWithoutSelf(context)) {
            for (PluginModule pluginModule : ideaPlugin.getModules()) {
                ContainerUtil.addIfNotNull(result, (Object)((String)pluginModule.getValue().getValue()));
            }
        }
        return result;
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s == null ? null : (IdeaPlugin)ContainerUtil.getFirstItem(PluginIdModuleIndex.findPlugins(context.getInvocationElement(), s));
    }

    private static Collection<IdeaPlugin> getAllPluginsWithoutSelf(ConvertContext context) {
        IdeaPlugin self = (IdeaPlugin)context.getInvocationElement().getParentOfType(IdeaPlugin.class, true);
        if (self == null) {
            return Collections.emptyList();
        }
        Collection<IdeaPlugin> plugins = IdeaPluginConverter.getAllPlugins(context.getProject());
        return ContainerUtil.filter(plugins, plugin -> !Comparing.strEqual((String)self.getPluginId(), (String)plugin.getPluginId()));
    }

    private static Collection<IdeaPlugin> getAllPlugins(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
            return CachedValueProvider.Result.create(DescriptorUtil.getPlugins(project, scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }
}

