/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.ide.TypeNameEP;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.notification.impl.NotificationGroupEP;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.SchemeConvertorEPBase;
import com.intellij.openapi.options.advanced.AdvancedSettingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.dom.Synonym;
import org.jetbrains.idea.devkit.dom.impl.PropertyKeyReferenceProvider;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class I18nReferenceContributor
extends PsiReferenceContributor {
    @NonNls
    private static final String INTENTION_ACTION_TAG = "intentionAction";
    @NonNls
    private static final String INTENTION_ACTION_BUNDLE_TAG = "bundleName";
    @NonNls
    private static final String SEPARATOR_TAG = "separator";
    @NonNls
    private static final String SYNONYM_TAG = "synonym";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        I18nReferenceContributor.registerKeyProviders(registrar);
        I18nReferenceContributor.registerBundleNameProviders(registrar);
        I18nReferenceContributor.registerLiveTemplateSetXml(registrar);
    }

    private static void registerKeyProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"key", "groupKey"}, Holder.CONFIGURABLE_EP, Holder.INSPECTION_EP, Holder.NOTIFICATION_GROUP_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", "groupBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.nestedExtensionAttributePattern(new String[]{"key", "groupKey"}, Holder.CONFIGURABLE_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", "groupBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"groupPathKey"}, Holder.INSPECTION_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupPathKey", "groupBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"nameKey"}, Holder.SCHEME_CONVERTER_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "nameKey", "nameBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"displayNameKey"}, "com.intellij.openapi.options.ex.ConfigurableGroupEP"), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "displayNameKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.OptionsBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"descriptionKey"}, "com.intellij.openapi.options.ex.ConfigurableGroupEP"), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "descriptionKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.OptionsBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"resourceKey"}, Holder.TYPE_NAME_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "resourceKey", "resourceBundle"));
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"displayName"}, "com.intellij.spring.toolWindow.SpringToolWindowContent"), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "displayName", "bundle"));
        XmlAttributeValuePattern idAttributeWithoutTitleKeyPattern = (XmlAttributeValuePattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"id"}, Holder.ADVANCED_SETTINGS_EP).andNot((ElementPattern)XmlPatterns.xmlAttributeValue().withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withChild((ElementPattern)XmlPatterns.xmlAttribute((String)"titleKey"))));
        registrar.registerReferenceProvider((ElementPattern)idAttributeWithoutTitleKeyPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "id", null){

            @Override
            @NotNull
            protected String getFinalKeyValue(String keyValue) {
                return "advanced.setting." + keyValue;
            }

            @Override
            protected String getFallbackBundleName() {
                return "messages.ApplicationBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"titleKey"}, Holder.ADVANCED_SETTINGS_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "titleKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.ApplicationBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"groupKey"}, Holder.ADVANCED_SETTINGS_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.ApplicationBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"descriptionKey"}, Holder.ADVANCED_SETTINGS_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "descriptionKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.ApplicationBundle";
            }
        });
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"trailingLabelKey"}, Holder.ADVANCED_SETTINGS_EP), (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "trailingLabelKey", null){

            @Override
            protected String getFallbackBundleName() {
                return "messages.ApplicationBundle";
            }
        });
        XmlAttributeValuePattern separatorSynonymPattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"key"}).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{DomPatterns.tagWithDom((String)SEPARATOR_TAG, Separator.class), DomPatterns.tagWithDom((String)SYNONYM_TAG, Synonym.class)}));
        registrar.registerReferenceProvider((ElementPattern)separatorSynonymPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider((NullableFunction<? super XmlTag, String>)((NullableFunction)tag -> {
            DomElement domElement = DomUtil.getDomElement((PsiElement)tag);
            if (domElement == null) {
                return null;
            }
            Actions actions = (Actions)DomUtil.getParentOfType((DomElement)domElement, Actions.class, (boolean)true);
            return actions != null ? actions.getResourceBundle().getStringValue() : null;
        })));
        XmlTagPattern.Capture intentionActionKeyTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("categoryKey")).withParent((ElementPattern)DomPatterns.tagWithDom((String)INTENTION_ACTION_TAG, Extension.class));
        registrar.registerReferenceProvider((ElementPattern)intentionActionKeyTagPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(true, null, INTENTION_ACTION_BUNDLE_TAG));
    }

    private static void registerBundleNameProviders(PsiReferenceRegistrar registrar) {
        PsiReferenceProvider bundleReferenceProvider = I18nReferenceContributor.createBundleReferenceProvider();
        XmlTagPattern.Capture resourceBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("resource-bundle")).withParent((ElementPattern)DomPatterns.tagWithDom((String)"idea-plugin", IdeaPlugin.class));
        registrar.registerReferenceProvider((ElementPattern)resourceBundleTagPattern, bundleReferenceProvider);
        XmlAttributeValuePattern actionsResourceBundlePattern = (XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"resource-bundle"}).withSuperParent(2, (ElementPattern)DomPatterns.tagWithDom((String)"actions", Actions.class));
        registrar.registerReferenceProvider((ElementPattern)actionsResourceBundlePattern, bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"bundle", "groupBundle"}, Holder.CONFIGURABLE_EP, Holder.INSPECTION_EP, "com.intellij.openapi.options.ex.ConfigurableGroupEP", Holder.NOTIFICATION_GROUP_EP, "com.intellij.spring.toolWindow.SpringToolWindowContent", Holder.ADVANCED_SETTINGS_EP), bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.nestedExtensionAttributePattern(new String[]{"bundle", "groupBundle"}, Holder.CONFIGURABLE_EP), bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"nameBundle"}, Holder.SCHEME_CONVERTER_EP), bundleReferenceProvider);
        registrar.registerReferenceProvider((ElementPattern)I18nReferenceContributor.extensionAttributePattern(new String[]{"resourceBundle"}, Holder.TYPE_NAME_EP, Holder.ICON_DESCRIPTION_BUNDLE_EP), bundleReferenceProvider);
        XmlTagPattern.Capture intentionActionBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(INTENTION_ACTION_BUNDLE_TAG)).withParent((ElementPattern)DomPatterns.tagWithDom((String)INTENTION_ACTION_TAG, Extension.class));
        registrar.registerReferenceProvider((ElementPattern)intentionActionBundleTagPattern, bundleReferenceProvider);
    }

    private static XmlAttributeValuePattern extensionAttributePattern(@NonNls String[] attributeNames, String ... extensionPointClassNames) {
        return (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])attributeNames).inFile((ElementPattern)DomPatterns.inDomFile(IdeaPlugin.class))).withSuperParent(2, (ElementPattern)I18nReferenceContributor.extensionPointCapture(extensionPointClassNames));
    }

    private static XmlAttributeValuePattern nestedExtensionAttributePattern(@NonNls String[] attributeNames, String ... extensionPointClassNames) {
        return (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])attributeNames).inFile((ElementPattern)DomPatterns.inDomFile(IdeaPlugin.class))).withSuperParent(3, (ElementPattern)I18nReferenceContributor.extensionPointCapture(extensionPointClassNames));
    }

    @NotNull
    private static XmlTagPattern.Capture extensionPointCapture(final @NonNls String[] extensionPointClassNames) {
        return (XmlTagPattern.Capture)XmlPatterns.xmlTag().and((ElementPattern)DomPatterns.withDom((ElementPattern)DomPatterns.domElement(Extension.class).with((PatternCondition)new PatternCondition<Extension>("relevantEP"){

            public boolean accepts(@NotNull Extension extension, ProcessingContext context) {
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint == null) {
                    return false;
                }
                PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
                for (String name : extensionPointClassNames) {
                    if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)name)) continue;
                    return true;
                }
                return false;
            }
        })));
    }

    private static void registerLiveTemplateSetXml(PsiReferenceRegistrar registrar) {
        XmlTagPattern.Capture templateTagCapture = (XmlTagPattern.Capture)((XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("template")).withParent((ElementPattern)XmlPatterns.xmlTag().withLocalName("templateSet"))).with((PatternCondition)new PatternCondition<XmlTag>("pluginProject"){

            public boolean accepts(@NotNull XmlTag tag, ProcessingContext context) {
                return PsiUtil.isPluginProject(tag.getProject());
            }
        });
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"key"}).withSuperParent(2, (ElementPattern)templateTagCapture), (PsiReferenceProvider)new PropertyKeyReferenceProvider((NullableFunction<? super XmlTag, String>)((NullableFunction)tag -> tag.getAttributeValue("resource-bundle"))));
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"resource-bundle"}).withSuperParent(2, (ElementPattern)templateTagCapture), I18nReferenceContributor.createBundleReferenceProvider());
    }

    @NotNull
    private static PsiReferenceProvider createBundleReferenceProvider() {
        return new PsiReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                return target instanceof PsiFile && PropertiesImplUtil.isPropertiesFile((PsiFile)((PsiFile)target));
            }

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return new PsiReference[]{new MyResourceBundleReference(element)};
            }
        };
    }

    @NonNls
    private static class Holder {
        private static final String GROUP_CONFIGURABLE_EP = "com.intellij.openapi.options.ex.ConfigurableGroupEP";
        private static final String CONFIGURABLE_EP = ConfigurableEP.class.getName();
        private static final String INSPECTION_EP = InspectionEP.class.getName();
        private static final String NOTIFICATION_GROUP_EP = NotificationGroupEP.class.getName();
        private static final String SCHEME_CONVERTER_EP = SchemeConvertorEPBase.class.getName();
        private static final String ICON_DESCRIPTION_BUNDLE_EP = IconDescriptionBundleEP.class.getName();
        private static final String TYPE_NAME_EP = TypeNameEP.class.getName();
        private static final String ADVANCED_SETTINGS_EP = AdvancedSettingBean.class.getName();
        private static final String SPRING_TOOL_WINDOW_CONTENT = "com.intellij.spring.toolWindow.SpringToolWindowContent";

        private Holder() {
        }
    }

    private static final class MyResourceBundleReference
    extends ResourceBundleReference
    implements EmptyResolveMessageProvider {
        private MyResourceBundleReference(PsiElement element) {
            super(element, false);
        }

        public Object @NotNull [] getVariants() {
            Project project = this.myElement.getProject();
            PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance((Project)project);
            ArrayList variants = new ArrayList();
            referenceManager.processPropertiesFiles(GlobalSearchScopesCore.projectProductionScope((Project)project), (baseName, propertiesFile) -> {
                Icon icon = propertiesFile.getContainingFile().getIcon(2);
                String relativePath = ProjectUtil.calcRelativeToProjectPath((VirtualFile)propertiesFile.getVirtualFile(), (Project)project);
                variants.add(LookupElementBuilder.create((Object)propertiesFile, (String)baseName).withIcon(icon).withTailText(" (" + relativePath + ")", true));
                return true;
            }, (BundleNameEvaluator)this);
            return variants.toArray(LookupElement.EMPTY_ARRAY);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return DevKitBundle.message("plugin.xml.convert.property.bundle.cannot.resolve", new Object[0]);
        }
    }
}

