/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.ExtensionsDomExtender;
import org.jetbrains.idea.devkit.dom.impl.IdeaPluginConverterBase;
import org.jetbrains.idea.devkit.dom.index.PluginIdModuleIndex;

public class ExtensionNsConverter
extends IdeaPluginConverterBase {
    @NotNull
    public Collection<? extends IdeaPlugin> getVariants(ConvertContext context) {
        IdeaPlugin ideaPlugin = (IdeaPlugin)context.getInvocationElement().getParentOfType(IdeaPlugin.class, true);
        if (ideaPlugin == null) {
            return Collections.emptyList();
        }
        Collection<String> dependencies = ExtensionsDomExtender.getDependencies(ideaPlugin);
        ArrayList depPlugins = new ArrayList();
        for (String dependency : dependencies) {
            ContainerUtil.addIfNotNull(depPlugins, (Object)ExtensionNsConverter.findById(ideaPlugin, dependency));
        }
        return depPlugins;
    }

    public IdeaPlugin fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s == null ? null : ExtensionNsConverter.findById(context.getInvocationElement(), s);
    }

    @Nullable
    private static IdeaPlugin findById(@NotNull DomElement place, @NotNull String id) {
        return (IdeaPlugin)ContainerUtil.find(PluginIdModuleIndex.findPlugins(place, id), plugin -> id.equals(plugin.getPluginId()));
    }
}

