/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.google.common.base.CaseFormat;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spellchecker.xml.NoSpellchecking;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ExtendClassImpl;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xmlb.annotations.Tag;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.With;
import org.jetbrains.idea.devkit.dom.impl.ActionOrGroupResolveConverter;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingConverter;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.references.extensions.ExtensionPointBinding;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ExtensionDomExtender
extends DomExtender<Extension> {
    private static final XmlName IMPLEMENTATION_XML_NAME = new XmlName("implementation");
    private static final PsiClassConverter CLASS_CONVERTER = new PluginPsiClassConverter();
    private static final LanguageResolvingConverter LANGUAGE_CONVERTER = new LanguageResolvingConverter();
    private static final ActionOrGroupResolveConverter ACTION_CONVERTER = new ActionOrGroupResolveConverter.OnlyActions();

    public void registerExtensions(@NotNull Extension extension, @NotNull DomExtensionsRegistrar registrar) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        String interfaceName = extensionPoint.getInterface().getStringValue();
        if (interfaceName != null) {
            DomExtension implementationAttribute = registrar.registerGenericAttributeValueChildExtension(IMPLEMENTATION_XML_NAME, PsiClass.class).setConverter((Converter)CLASS_CONVERTER).addCustomAnnotation((Annotation)((Object)new MyImplementationExtendClass(interfaceName))).addCustomAnnotation((Annotation)((Object)MyRequired.INSTANCE));
            PsiClass interfaceClass = (PsiClass)extensionPoint.getInterface().getValue();
            if (interfaceClass != null) {
                implementationAttribute.setDeclaringElement((PsiElement)interfaceClass);
            } else {
                implementationAttribute.setDeclaringElement((DomElement)extensionPoint);
            }
            ExtensionDomExtender.registerXmlb(registrar, interfaceClass, Collections.emptyList());
        } else {
            PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
            ExtensionDomExtender.registerXmlb(registrar, beanClass, extensionPoint.getWithElements());
        }
    }

    private static void registerXmlb(final DomExtensionsRegistrar registrar, @Nullable PsiClass psiClass, final @NotNull List<With> elements) {
        if (psiClass == null) {
            return;
        }
        ExtensionPointBinding binding = new ExtensionPointBinding(psiClass);
        binding.visit(new ExtensionPointBinding.BindingVisitor(){

            @Override
            public void visitAttribute(@NotNull PsiField field, @NotNull @NonNls String attributeName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                With withElement = ExtensionDomExtender.findWithElement(elements, field);
                PsiType fieldType = field.getType();
                Class clazz = String.class;
                if (PsiType.BOOLEAN.equals((Object)fieldType)) {
                    clazz = Boolean.class;
                } else if (PsiType.INT.equals((Object)fieldType) || fieldType.equalsToText("java.lang.Integer")) {
                    clazz = Integer.class;
                } else if (withElement != null || Extension.isClassField(attributeName)) {
                    clazz = PsiClass.class;
                }
                DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(attributeName), clazz).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                if (clazz == String.class) {
                    ExtensionDomExtender.markStringProperty(extension, field, fieldType, attributeName);
                } else if (clazz == PsiClass.class) {
                    ExtensionDomExtender.markAsClass(extension, true, withElement);
                }
            }

            @Override
            public void visitTagOrProperty(@NotNull PsiField field, @NotNull String tagName, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                DomExtension extension = registrar.registerFixedNumberChildExtension(new XmlName(tagName), SimpleTagValue.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                With withElement = ExtensionDomExtender.findWithElement(elements, field);
                ExtensionDomExtender.markAsClass(extension, Extension.isClassField(field.getName()), withElement);
                ExtensionDomExtender.markStringProperty(extension, field, field.getType(), tagName);
            }

            @Override
            public void visitXCollection(final @NotNull PsiField field, @Nullable String tagName, final @NotNull PsiAnnotation collectionAnnotation, final ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
                if (tagName == null) {
                    ExtensionDomExtender.registerCollectionBinding(field, registrar, collectionAnnotation, required);
                    return;
                }
                registrar.registerFixedNumberChildExtension(new XmlName(tagName), DomElement.class).addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        ExtensionDomExtender.registerCollectionBinding(field, registrar, collectionAnnotation, required);
                    }
                });
            }
        });
    }

    @Nullable
    static With findWithElement(List<? extends With> withElements, PsiField field) {
        for (With with : withElements) {
            PsiField withPsiField;
            PsiField psiField = withPsiField = DomUtil.hasXml(with.getTag()) ? (PsiField)with.getTag().getValue() : (PsiField)with.getAttribute().getValue();
            if (!field.getManager().areElementsEquivalent((PsiElement)field, (PsiElement)withPsiField)) continue;
            return with;
        }
        return null;
    }

    private static void markAsClass(DomExtension extension, boolean isClassField, @Nullable With withElement) {
        if (withElement != null) {
            final String withClassName = withElement.getImplements().getStringValue();
            extension.addCustomAnnotation((Annotation)new ExtendClassImpl(){

                public String[] value() {
                    return new String[]{withClassName};
                }
            });
        }
        if (withElement != null || isClassField) {
            extension.setConverter((Converter)CLASS_CONVERTER);
        }
    }

    private static void markAsRequired(DomExtension extension, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
        if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED) {
            extension.addCustomAnnotation((Annotation)((Object)MyRequired.INSTANCE));
        } else if (required == ExtensionPointBinding.BindingVisitor.RequiredFlag.REQUIRED_ALLOW_EMPTY) {
            extension.addCustomAnnotation((Annotation)((Object)MyRequiredCanBeEmpty.INSTANCE));
        }
    }

    private static void markStringProperty(DomExtension extension, PsiField field, PsiType fieldType, String propertyName) {
        PsiClass fieldPsiClass;
        if (PsiUtil.findAnnotation(NonNls.class, new PsiMember[]{field}) != null) {
            extension.addCustomAnnotation((Annotation)((Object)MyNoSpellchecking.INSTANCE));
        } else if (!fieldType.equalsToText("java.lang.String") && (fieldPsiClass = PsiTypesUtil.getPsiClass((PsiType)fieldType)) != null && fieldPsiClass.isEnum()) {
            extension.setConverter(ExtensionDomExtender.createEnumConverter(fieldPsiClass));
            return;
        }
        if ("language".equals(propertyName) || StringUtil.endsWith((CharSequence)propertyName, (CharSequence)"Language")) {
            extension.setConverter((Converter)LANGUAGE_CONVERTER);
        } else if ("action".equals(propertyName)) {
            extension.setConverter((Converter)ACTION_CONVERTER);
        }
    }

    private static void registerCollectionBinding(PsiField field, DomExtensionsRegistrar registrar, PsiAnnotation collectionAnnotation, ExtensionPointBinding.BindingVisitor.RequiredFlag required) {
        boolean surroundWithTag = PsiUtil.getAnnotationBooleanAttribute(collectionAnnotation, "surroundWithTag");
        if (surroundWithTag) {
            return;
        }
        String tagName = PsiUtil.getAnnotationStringAttribute(collectionAnnotation, "elementTag", null);
        final String attrName = PsiUtil.getAnnotationStringAttribute(collectionAnnotation, "elementValueAttribute", null);
        PsiType elementType = ExtensionDomExtender.getElementType(field.getType());
        if (elementType == null || TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)elementType) || "java.lang.String".equals(elementType.getCanonicalText()) || TypeConversionUtil.isEnumType((PsiType)elementType)) {
            if (tagName != null && attrName == null) {
                DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(tagName), SimpleTagValue.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
            } else if (tagName != null) {
                DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(tagName), DomElement.class).setDeclaringElement((PsiElement)field);
                ExtensionDomExtender.markAsRequired(extension, required);
                extension.addExtender(new DomExtender(){

                    public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                        registrar.registerGenericAttributeValueChildExtension(new XmlName(attrName), String.class);
                    }
                });
            }
        } else {
            final PsiClass elementPsiClass = PsiTypesUtil.getPsiClass((PsiType)elementType);
            if (elementPsiClass != null) {
                String classTagName;
                PsiModifierList modifierList = elementPsiClass.getModifierList();
                PsiAnnotation tagAnno = modifierList == null ? null : modifierList.findAnnotation(Tag.class.getName());
                String string = classTagName = tagAnno == null ? elementPsiClass.getName() : PsiUtil.getAnnotationStringAttribute(tagAnno, "value", null);
                if (classTagName != null) {
                    DomExtension extension = registrar.registerCollectionChildrenExtension(new XmlName(classTagName), DomElement.class).setDeclaringElement((PsiElement)field);
                    ExtensionDomExtender.markAsRequired(extension, required);
                    extension.addExtender(new DomExtender(){

                        public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                            ExtensionDomExtender.registerXmlb(registrar, elementPsiClass, Collections.emptyList());
                        }
                    });
                }
            }
        }
    }

    @Nullable
    private static PsiType getElementType(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return ((PsiArrayType)psiType).getComponentType();
        }
        if (psiType instanceof PsiClassType) {
            PsiType[] types = ((PsiClassType)psiType).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        return null;
    }

    @NotNull
    private static ResolvingConverter<PsiEnumConstant> createEnumConverter(PsiClass fieldPsiClass) {
        return new PsiEnumConstantResolvingConverter(fieldPsiClass.getQualifiedName());
    }

    private static final class MyImplementationExtendClass
    extends ExtendClassImpl {
        private final String myInterfaceName;

        private MyImplementationExtendClass(String interfaceName) {
            this.myInterfaceName = interfaceName;
        }

        public boolean allowAbstract() {
            return false;
        }

        public boolean allowInterface() {
            return false;
        }

        public boolean allowEnum() {
            return false;
        }

        public String[] value() {
            return new String[]{this.myInterfaceName};
        }
    }

    private static class MyRequired
    implements Required {
        private static final MyRequired INSTANCE = new MyRequired();

        private MyRequired() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    private static class MyRequiredCanBeEmpty
    implements Required {
        private static final MyRequiredCanBeEmpty INSTANCE = new MyRequiredCanBeEmpty();

        private MyRequiredCanBeEmpty() {
        }

        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return false;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    private static class MyNoSpellchecking
    implements NoSpellchecking {
        private static final MyNoSpellchecking INSTANCE = new MyNoSpellchecking();

        private MyNoSpellchecking() {
        }

        public Class<? extends Annotation> annotationType() {
            return NoSpellchecking.class;
        }
    }

    public static interface SimpleTagValue
    extends GenericDomValue<String> {
    }

    private static class PsiEnumConstantResolvingConverter
    extends ResolvingConverter<PsiEnumConstant> {
        private final String myEnumFqn;
        private static final Set<String> LEGACY_ENUM_NOTATION_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"com.intellij.compiler.CompileTaskBean.CompileTaskExecutionPhase", "com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerKind", "com.intellij.notification.impl.NotificationGroupEP.DisplayType"});
        private static final Set<String> LOWER_UNDERSCORE_ENUM_NOTATION_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"com.intellij.ui.viewModel.extraction.ToolWindowExtractorMode"});

        PsiEnumConstantResolvingConverter(String enumFqn) {
            this.myEnumFqn = enumFqn;
        }

        public String getErrorMessage(@Nullable String s, ConvertContext context) {
            return DevKitBundle.message("plugin.xml.convert.enum.cannot.resolve", s, this.myEnumFqn);
        }

        @NotNull
        public Collection<? extends PsiEnumConstant> getVariants(ConvertContext context) {
            PsiClass enumClass = this.getEnumClass(context);
            if (enumClass == null) {
                return Collections.emptyList();
            }
            return ContainerUtil.findAll((Object[])enumClass.getFields(), PsiEnumConstant.class);
        }

        @Nullable
        public LookupElement createLookupElement(PsiEnumConstant constant) {
            return JavaLookupElementBuilder.forField((PsiField)constant, (String)this.toXmlName(constant), null);
        }

        @Nullable
        public PsiEnumConstant fromString(@Nullable String s, ConvertContext context) {
            if (s == null) {
                return null;
            }
            PsiClass enumClass = this.getEnumClass(context);
            if (enumClass == null) {
                return null;
            }
            PsiField name = enumClass.findFieldByName(this.fromXmlName(s), false);
            return name instanceof PsiEnumConstant ? (PsiEnumConstant)name : null;
        }

        @Nullable
        public String toString(@Nullable PsiEnumConstant constant, ConvertContext context) {
            return constant == null ? null : this.toXmlName(constant);
        }

        @Nullable
        private PsiClass getEnumClass(ConvertContext context) {
            return DomJavaUtil.findClass((String)this.myEnumFqn, (DomElement)context.getInvocationElement());
        }

        private String fromXmlName(@NotNull String name) {
            if (this.doNotTransformName()) {
                return name;
            }
            if (this.enumLowerUnderscore()) {
                return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, name);
            }
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
        }

        private String toXmlName(PsiEnumConstant constant) {
            String name = constant.getName();
            if (this.doNotTransformName()) {
                return name;
            }
            if (this.enumLowerUnderscore()) {
                return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, name);
            }
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        }

        private boolean doNotTransformName() {
            return LEGACY_ENUM_NOTATION_CLASSES.contains(this.myEnumFqn);
        }

        private boolean enumLowerUnderscore() {
            return LOWER_UNDERSCORE_ENUM_NOTATION_CLASSES.contains(this.myEnumFqn);
        }
    }
}

