/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ExtensionOrderKeywordCompletionContributor
extends CompletionContributor {
    private static final LookupElementBuilder KEYWORD_VARIANT_FIRST = LookupElementBuilder.create((String)"first");
    private static final LookupElementBuilder KEYWORD_VARIANT_LAST = LookupElementBuilder.create((String)"last");
    private static final LookupElementBuilder KEYWORD_VARIANT_BEFORE = LookupElementBuilder.create((String)"before ".trim()).withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP);
    private static final LookupElementBuilder KEYWORD_VARIANT_AFTER = LookupElementBuilder.create((String)"after ".trim()).withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP);

    public ExtensionOrderKeywordCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)ExtensionOrderKeywordCompletionContributor.getCapture(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                String prefix = ExtensionOrderKeywordCompletionContributor.getCompletionPrefix(parameters);
                if (!ExtensionOrderKeywordCompletionContributor.shouldProposeKeywordsAfterPrefix(prefix)) {
                    return;
                }
                if (ExtensionOrderKeywordCompletionContributor.shouldProposeFirstLastKeywordsAfterPrefix(prefix)) {
                    result.addElement((LookupElement)KEYWORD_VARIANT_FIRST);
                    result.addElement((LookupElement)KEYWORD_VARIANT_LAST);
                }
                result.addElement((LookupElement)KEYWORD_VARIANT_BEFORE);
                result.addElement((LookupElement)KEYWORD_VARIANT_AFTER);
            }
        });
    }

    @NotNull
    private static PsiElementPattern.Capture<PsiElement> getCapture() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"order"}).inside((ElementPattern)XmlPatterns.xmlTag().with((PatternCondition)new PatternCondition<XmlTag>("extension tag"){

            public boolean accepts(@NotNull XmlTag tag, ProcessingContext context) {
                if (!PsiUtil.isPluginXmlPsiElement((PsiElement)tag)) {
                    return false;
                }
                DomManager domManager = DomManager.getDomManager((Project)tag.getProject());
                return domManager.getDomElement(tag) instanceof Extension;
            }
        })));
    }

    @NotNull
    private static String getCompletionPrefix(@NotNull CompletionParameters parameters) {
        XmlElement position = (XmlElement)parameters.getPosition();
        int startOffset = position.getTextOffset();
        int endOffset = parameters.getOffset();
        Document document = parameters.getEditor().getDocument();
        return document.getText(new TextRange(startOffset, endOffset));
    }

    @NotNull
    private static String getPrefixLastPart(@NotNull String prefix) {
        String lastPart = StringUtil.substringAfterLast((String)prefix, (String)",");
        if (lastPart == null) {
            lastPart = prefix;
        }
        lastPart = StringUtil.trimLeading((String)lastPart);
        return lastPart;
    }

    private static boolean shouldProposeKeywordsAfterPrefix(@NotNull String prefix) {
        return !ExtensionOrderKeywordCompletionContributor.getPrefixLastPart(prefix).contains(" ");
    }

    private static boolean shouldProposeFirstLastKeywordsAfterPrefix(@NotNull String prefix) {
        String[] parts;
        for (String part : parts = prefix.split(",")) {
            if (!part.trim().equalsIgnoreCase("first") && !part.trim().equalsIgnoreCase("last")) continue;
            return false;
        }
        return true;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String prefix = result.getPrefixMatcher().getPrefix();
        result = prefix.endsWith(",") ? result.withPrefixMatcher("") : result.withPrefixMatcher(ExtensionOrderKeywordCompletionContributor.getPrefixLastPart(prefix));
        super.fillCompletionVariants(parameters, result);
    }
}

