/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public final class ShuffleNamesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(editor != null && file != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return;
        }
        Project project = file.getProject();
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file.getVirtualFile()})) {
            return;
        }
        CommandProcessorEx commandProcessor = (CommandProcessorEx)CommandProcessorEx.getInstance();
        CommandToken commandToken = commandProcessor.startCommand(project, e.getPresentation().getText(), (Object)e.getPresentation().getText(), UndoConfirmationPolicy.DEFAULT);
        try {
            WriteAction.run(() -> ShuffleNamesAction.shuffleIds(file, editor));
        }
        finally {
            commandProcessor.finishCommand(commandToken, null);
        }
    }

    private static boolean shuffleIds(PsiFile file, Editor editor) {
        final HashMap map = new HashMap();
        final StringBuilder sb = new StringBuilder();
        final StringBuilder quote = new StringBuilder();
        final ArrayList split = new ArrayList(100);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof LeafPsiElement) {
                    char c;
                    String type = ((LeafPsiElement)element).getElementType().toString();
                    String text = element.getText();
                    if (text.isEmpty()) {
                        return;
                    }
                    int len = text.length();
                    for (int i = 0; i < len / 2 && (c = text.charAt(i)) == text.charAt(len - i - 1) && !Character.isLetter(c); ++i) {
                        quote.append(c);
                    }
                    boolean isQuoted = quote.length() > 0;
                    boolean isNumber = false;
                    if (isQuoted || type.equals("ID") || type.equals("word") || type.contains("IDENT") && !"ts".equals(text) || (isNumber = text.matches("[0-9]+"))) {
                        Object replacement = (String)map.get(text);
                        if (replacement == null) {
                            split.addAll(Arrays.asList((isQuoted ? text.substring(quote.length(), text.length() - quote.length()).replace("''", "") : text).split("")));
                            if (!isNumber) {
                                ListIterator<String> it = split.listIterator();
                                while (it.hasNext()) {
                                    int cap;
                                    String s = (String)it.next();
                                    if (s.isEmpty()) {
                                        it.remove();
                                        continue;
                                    }
                                    int c2 = s.charAt(0);
                                    c2 = (char)((c2 &= ~(cap = c2 & 0x20)) >= 65 && c2 <= 90 ? (c2 - 65 + 7) % 26 + 65 : c2) | cap;
                                    it.set(String.valueOf((char)c2));
                                }
                            }
                            Collections.shuffle(split);
                            if (isNumber && "0".equals(split.get(0))) {
                                split.set(0, "1");
                            }
                            replacement = StringUtil.join((Collection)split, (String)"");
                            if (isQuoted) {
                                replacement = quote + (String)replacement + quote.reverse();
                            }
                            map.put(text, replacement);
                        }
                        text = replacement;
                    }
                    sb.append(text);
                    quote.setLength(0);
                    split.clear();
                }
                super.visitElement(element);
            }
        });
        editor.getDocument().setText((CharSequence)sb.toString());
        return true;
    }
}

