/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.codegen;

import com.intellij.workspaceModel.codegen.InterfaceVisitor;
import com.intellij.workspaceModel.codegen.deft.meta.ObjClass;
import com.intellij.workspaceModel.codegen.deft.meta.OwnProperty;
import com.intellij.workspaceModel.codegen.deft.meta.ValueType;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\u00020\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/workspaceModel/codegen/InterfaceTraverser;", "", "()V", "traverse", "", "myInterface", "Lcom/intellij/workspaceModel/codegen/deft/meta/ObjClass;", "visitor", "Lcom/intellij/workspaceModel/codegen/InterfaceVisitor;", "traverseField", "field", "Lcom/intellij/workspaceModel/codegen/deft/meta/OwnProperty;", "varName", "", "traverseType", "type", "Lcom/intellij/workspaceModel/codegen/deft/meta/ValueType;", "intellij.platform.workspaceModel.codegen"})
public final class InterfaceTraverser {
    public final boolean traverse(@NotNull ObjClass<?> myInterface, @NotNull InterfaceVisitor visitor) {
        for (OwnProperty<?, ?> field : myInterface.getFields()) {
            boolean res = this.traverseField(field, visitor, field.getName());
            if (res) continue;
            return false;
        }
        return true;
    }

    private final boolean traverseField(OwnProperty<?, ?> field, InterfaceVisitor visitor, String varName) {
        return this.traverseType(field.getValueType(), visitor, varName);
    }

    private final boolean traverseType(ValueType<?> type, InterfaceVisitor visitor, String varName) {
        ValueType<?> valueType = type;
        if (valueType instanceof ValueType.Boolean) {
            return visitor.visitBoolean(varName);
        }
        if (valueType instanceof ValueType.Int) {
            return visitor.visitInt(varName);
        }
        if (valueType instanceof ValueType.String) {
            return visitor.visitString(varName);
        }
        if (valueType instanceof ValueType.Collection) {
            String itemVarName = "_" + varName;
            boolean shouldProcessList = visitor.visitListStart(varName, itemVarName, ((ValueType.Collection)type).getElementType());
            if (!shouldProcessList) {
                return false;
            }
            boolean traversingResult = this.traverseType(((ValueType.Collection)type).getElementType(), visitor, itemVarName);
            return visitor.visitListEnd(varName, itemVarName, traversingResult, ((ValueType.Collection)type).getElementType());
        }
        if (valueType instanceof ValueType.Map) {
            String valueVarName;
            String keyVarName = "key_" + varName;
            boolean shouldProcessMap = visitor.visitMapStart(varName, keyVarName, valueVarName = "value_" + varName, ((ValueType.Map)type).getKeyType(), ((ValueType.Map)type).getValueType());
            if (!shouldProcessMap) {
                return false;
            }
            boolean keyTraverseResult = this.traverseType(((ValueType.Map)type).getKeyType(), visitor, keyVarName);
            boolean valueTraverseResult = this.traverseType(((ValueType.Map)type).getValueType(), visitor, valueVarName);
            return visitor.visitMapEnd(varName, keyVarName, valueVarName, ((ValueType.Map)type).getKeyType(), ((ValueType.Map)type).getValueType(), keyTraverseResult && valueTraverseResult);
        }
        if (valueType instanceof ValueType.Optional) {
            String notNullVarName = "_" + varName;
            boolean continueProcess = visitor.visitOptionalStart(varName, notNullVarName, ((ValueType.Optional)type).getType());
            if (!continueProcess) {
                return false;
            }
            continueProcess = this.traverseType(((ValueType.Optional)type).getType(), visitor, notNullVarName);
            return visitor.visitOptionalEnd(varName, notNullVarName, ((ValueType.Optional)type).getType(), continueProcess);
        }
        if (valueType instanceof ValueType.Blob) {
            return visitor.visitUnknownBlob(varName, ((ValueType.Blob)type).getJavaClassName());
        }
        if (valueType instanceof ValueType.DataClass) {
            boolean process = visitor.visitDataClassStart(varName, (ValueType.DataClass)type);
            if (!process) {
                return false;
            }
            return visitor.visitDataClassEnd(varName, (ValueType.DataClass)type, process);
        }
        return true;
    }
}

