/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.devkit.workspaceModel.WorkspaceModelGeneratorKt;
import com.intellij.devkit.workspaceModel.codegen.writer.CodeWriter;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/devkit/workspaceModel/WorkspaceModelGenerator;", "", "()V", "GENERATED_FOLDER_NAME", "", "createGeneratedSourceFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "generate", "", "project", "Lcom/intellij/openapi/project/Project;", "getSourceRoot", "", "intellij.devkit.workspaceModel"})
public final class WorkspaceModelGenerator {
    @NotNull
    public static final WorkspaceModelGenerator INSTANCE = new WorkspaceModelGenerator();
    @NotNull
    private static final String GENERATED_FOLDER_NAME = "gen";

    private WorkspaceModelGenerator() {
    }

    public final void generate(@NotNull Project project, @NotNull Module module) {
        List<SourceFolder> acceptedSourceRoots = this.getSourceRoot(module);
        if (acceptedSourceRoots.isEmpty()) {
            WorkspaceModelGeneratorKt.access$getLOG$p().info("Acceptable module source roots not found");
            return;
        }
        Iterable $this$forEach$iv = acceptedSourceRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceFolder sourceRoot = (SourceFolder)element$iv;
            boolean bl = false;
            WriteAction.run(() -> WorkspaceModelGenerator.generate$lambda$1$lambda$0(project, module, sourceRoot));
        }
        System.out.println((Object)("Selected module " + module.getName()));
    }

    private final VirtualFile createGeneratedSourceFolder(Module module, SourceFolder sourceFolder) {
        VirtualFile generatedFolder = (VirtualFile)WriteAction.compute(() -> WorkspaceModelGenerator.createGeneratedSourceFolder$lambda$2(sourceFolder));
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel modifiableModel = moduleRootManager.getModifiableModel();
        for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
            SourceFolder existingGenFolder;
            block3: {
                SourceFolder sourceFolder2;
                VirtualFile contentEntryFile = contentEntry.getFile();
                if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)generatedFolder, (boolean)false)) continue;
                SourceFolder[] $this$firstOrNull$iv = contentEntry.getSourceFolders();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    SourceFolder element$iv;
                    SourceFolder it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    JpsElement jpsElement = it.getJpsElement().getProperties();
                    JavaSourceRootProperties javaSourceRootProperties = jpsElement instanceof JavaSourceRootProperties ? (JavaSourceRootProperties)jpsElement : null;
                    boolean bl2 = (javaSourceRootProperties != null ? javaSourceRootProperties.isForGeneratedSources() : false) && Intrinsics.areEqual((Object)it.getFile(), (Object)generatedFolder);
                    if (!bl2) continue;
                    sourceFolder2 = element$iv;
                    break block3;
                }
                sourceFolder2 = existingGenFolder = null;
            }
            if (existingGenFolder != null) {
                return generatedFolder;
            }
            JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties("", true);
            JavaSourceRootType sourceFolderType = sourceFolder.isTestSource() ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
            contentEntry.addSourceFolder(generatedFolder, (JpsModuleSourceRootType)sourceFolderType, (JpsElement)properties);
            WriteAction.run(() -> ((ModifiableRootModel)modifiableModel).commit());
            return generatedFolder;
        }
        modifiableModel.dispose();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SourceFolder> getSourceRoot(Module module) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        ContentEntry[] contentEntries;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Object $this$flatMap$iv = contentEntries = moduleRootManager.getContentEntries();
        boolean $i$f$flatMap = false;
        ContentEntry[] contentEntryArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.asIterable((Object[])it.getSourceFolders());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            SourceFolder it = (SourceFolder)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() == null) {
                bl = false;
            } else {
                JavaSourceRootProperties javaSourceRootProperties;
                JpsElement jpsElement = it.getJpsElement().getProperties();
                JavaSourceRootProperties javaSourceRootProperties2 = javaSourceRootProperties = jpsElement instanceof JavaSourceRootProperties ? (JavaSourceRootProperties)jpsElement : null;
                bl = javaSourceRootProperties == null ? true : !javaSourceRootProperties.isForGeneratedSources();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void generate$lambda$1$lambda$0(Project $project, Module $module, SourceFolder $sourceRoot) {
        VirtualFile virtualFile = $sourceRoot.getFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        CodeWriter.INSTANCE.generate($project, $module, virtualFile, (Function0<? extends VirtualFile>)((Function0)new Function0<VirtualFile>($module, $sourceRoot){
            final /* synthetic */ Module $module;
            final /* synthetic */ SourceFolder $sourceRoot;
            {
                this.$module = $module;
                this.$sourceRoot = $sourceRoot;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                return WorkspaceModelGenerator.access$createGeneratedSourceFolder(WorkspaceModelGenerator.INSTANCE, this.$module, this.$sourceRoot);
            }
        }));
    }

    private static final VirtualFile createGeneratedSourceFolder$lambda$2(SourceFolder $sourceFolder) {
        VirtualFile virtualFile = $sourceFolder.getFile();
        return VfsUtil.createDirectoryIfMissing((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null), (String)GENERATED_FOLDER_NAME);
    }

    public static final /* synthetic */ VirtualFile access$createGeneratedSourceFolder(WorkspaceModelGenerator $this, Module module, SourceFolder sourceFolder) {
        return $this.createGeneratedSourceFolder(module, sourceFolder);
    }
}

