/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.workspaceModel.storage.GeneratedCodeApiVersion;
import com.intellij.workspaceModel.storage.GeneratedCodeImplVersion;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import java.util.Collection;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.deft.annotations.Abstract;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u001a\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0003\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0006*\u00020\u0002H\u0000\u00a8\u0006\b"}, d2={"getApiVersion", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;)Ljava/lang/Integer;", "getImplVersion", "isAbstractEntity", "", "isWorkspaceEntity", "intellij.devkit.workspaceModel"})
public final class WorkspaceKtClassExtentionsKt {
    public static final boolean isWorkspaceEntity(@NotNull KtClass $this$isWorkspaceEntity) {
        if (!$this$isWorkspaceEntity.isInterface()) {
            return false;
        }
        LinkedList<KtSuperTypeListEntry> superTypeList = new LinkedList<KtSuperTypeListEntry>();
        superTypeList.addAll($this$isWorkspaceEntity.getSuperTypeListEntries());
        while (!superTypeList.isEmpty()) {
            KtClass resolvedKtClass;
            PsiElement psiElement;
            KtSuperTypeListEntry superType = (KtSuperTypeListEntry)superTypeList.pop();
            KtTypeReference ktTypeReference = superType.getTypeReference();
            Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            KtUserType ktUserType = object instanceof KtUserType ? (KtUserType)object : null;
            PsiElement psiElement2 = psiElement = ktUserType != null && (ktUserType = ktUserType.getReferenceExpression()) != null && (ktUserType = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktUserType)) != null ? ktUserType.resolve() : null;
            if ((psiElement instanceof KtClass ? (KtClass)psiElement : null) == null) continue;
            resolvedKtClass = resolvedKtClass;
            FqName fqName = resolvedKtClass.getFqName();
            if (Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)Reflection.getOrCreateKotlinClass(WorkspaceEntity.class).getQualifiedName())) {
                return true;
            }
            Iterable $this$forEach$iv = resolvedKtClass.getSuperTypeListEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                superTypeList.push(it);
            }
        }
        return false;
    }

    public static final boolean isAbstractEntity(@NotNull KtClass $this$isAbstractEntity) {
        boolean bl;
        block3: {
            String annotationName = Reflection.getOrCreateKotlinClass(Abstract.class).getSimpleName();
            Iterable $this$any$iv = $this$isAbstractEntity.getAnnotationEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl2 = false;
                    Name name = it.getShortName();
                    if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final Integer getApiVersion(@NotNull KtClass $this$getApiVersion) {
        KtConstantExpression argumentExpression;
        Object v1;
        Iterable iterable;
        String annotationName;
        block5: {
            annotationName = Reflection.getOrCreateKotlinClass(GeneratedCodeApiVersion.class).getSimpleName();
            iterable = $this$getApiVersion.getAnnotationEntries();
            for (Object t : iterable) {
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                Name name = it.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        KtAnnotationEntry annotation = v1;
        if (annotation == null) {
            throw new IllegalStateException(($this$getApiVersion.getName() + " should contain " + annotationName).toString());
        }
        if (annotation.getValueArguments().size() != 1) {
            throw new IllegalStateException(("Annotation " + annotationName + " at " + $this$getApiVersion.getName() + " should contain only one argument").toString());
        }
        iterable = ((ValueArgument)annotation.getValueArguments().get(0)).getArgumentExpression();
        KtConstantExpression ktConstantExpression = argumentExpression = iterable instanceof KtConstantExpression ? (KtConstantExpression)iterable : null;
        if (argumentExpression == null) {
            throw new IllegalStateException("Annotation parameter should be int constant".toString());
        }
        IElementType elementType = argumentExpression.getNode().getElementType();
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            Number number = ParseUtilsKt.parseNumericLiteral((String)argumentExpression.getText(), (IElementType)elementType);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        return null;
    }

    @Nullable
    public static final Integer getImplVersion(@NotNull KtClass $this$getImplVersion) {
        KtConstantExpression argumentExpression;
        Object v1;
        Iterable iterable;
        String annotationName;
        block5: {
            annotationName = Reflection.getOrCreateKotlinClass(GeneratedCodeImplVersion.class).getSimpleName();
            iterable = $this$getImplVersion.getAnnotationEntries();
            for (Object t : iterable) {
                KtAnnotationEntry it = (KtAnnotationEntry)t;
                boolean bl = false;
                Name name = it.getShortName();
                if (!Intrinsics.areEqual((Object)(name != null ? name.getIdentifier() : null), (Object)annotationName)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        KtAnnotationEntry annotation = v1;
        if (annotation == null) {
            throw new IllegalStateException(($this$getImplVersion.getName() + " should contain " + annotationName).toString());
        }
        if (annotation.getValueArguments().size() != 1) {
            throw new IllegalStateException(("Annotation " + annotationName + " at " + $this$getImplVersion.getName() + " should contain only one argument").toString());
        }
        iterable = ((ValueArgument)annotation.getValueArguments().get(0)).getArgumentExpression();
        KtConstantExpression ktConstantExpression = argumentExpression = iterable instanceof KtConstantExpression ? (KtConstantExpression)iterable : null;
        if (argumentExpression == null) {
            throw new IllegalStateException("Annotation parameter should be int constant".toString());
        }
        IElementType elementType = argumentExpression.getNode().getElementType();
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            Number number = ParseUtilsKt.parseNumericLiteral((String)argumentExpression.getText(), (IElementType)elementType);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        return null;
    }
}

