/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.execution.testing.CidrTestIndexContributor;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionTestRunLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.testing.ClangBadTLMSource;
import com.jetbrains.cidr.lang.testing.ClangTestIndexScopeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor;", "Lcom/jetbrains/cidr/execution/testing/CidrTestIndexContributor;", "()V", "canProcessFile", "", "file", "Lcom/intellij/psi/PsiFile;", "framework", "", "extractTest", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "element", "Lcom/intellij/psi/PsiElement;", "indexedTests", "Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$CachedIndexedObjects;", "findTest", "gatherTestLinks", "", "getIndexedData", "mayBeDirty", "CachedIndexedObjects", "Companion", "intellij.c.clangdBridge"})
public final class ClangTestIndexContributor
extends CidrTestIndexContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<CachedIndexedObjects> CACHE_KEY = Key.create((String)"CLANG_INDEXED_TESTS_CACHE");
    @NotNull
    private static final List<String> ALL_FRAMEWORK_NAMES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CachedIndexedObjects getIndexedData(PsiFile file, boolean mayBeDirty) {
        VirtualFile vFile = file.getVirtualFile();
        Project project = file.getProject();
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        CachedIndexedObjects maybeCached = (CachedIndexedObjects)file.getUserData(CACHE_KEY);
        long version = file.getModificationStamp();
        if (maybeCached != null && (maybeCached.getFileVersion() == version || mayBeDirty)) {
            return maybeCached;
        }
        if (doc == null) {
            return new CachedIndexedObjects(version, MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        PsiFile psiFile = file;
        synchronized (psiFile) {
            void $this$associateTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Pair m;
            Object object;
            void $this$mapTo$iv$iv;
            block11: {
                boolean bl = false;
                CachedIndexedObjects maybeCacheUpdated = (CachedIndexedObjects)file.getUserData(CACHE_KEY);
                if (maybeCacheUpdated == null || maybeCacheUpdated.getFileVersion() != file.getModificationStamp()) break block11;
                CachedIndexedObjects cachedIndexedObjects = maybeCacheUpdated;
                return cachedIndexedObjects;
            }
            List rawMarkers = com.jetbrains.cidr.lang.testing.ClangTestIndexContributor$Companion.getAllTestLineMarkers$default(Companion, vFile, project, null, 4, null);
            Iterable $this$map$iv = rawMarkers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OCTestFramework oCTestFramework;
                block12: {
                    Iterator it;
                    ClionTestRunLineMarker clionTestRunLineMarker = (ClionTestRunLineMarker)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    m = it;
                    for (OCTestFramework it2 : (Iterable)OCTestFrameworks.getFrameworks()) {
                        boolean bl2 = false;
                        if ((it2 = it2.generateVirtualTestScopeElement(m.getSuiteName(), m.getTestName(), m.getTestFrameworkName())) == null) continue;
                        oCTestFramework = it2;
                        break block12;
                    }
                    oCTestFramework = null;
                }
                if (oCTestFramework == null) {
                    throw new ClangBadTLMSource();
                }
                OCTestFramework elem = oCTestFramework;
                int offset = doc.getLineStartOffset(m.getLineNumber()) + m.getColumnNumber();
                object.add(new Pair((Object)m, (Object)new ClangTestIndexScopeElement((CidrTestScopeElement)elem, vFile, project, offset)));
            }
            List result2 = (List)destination$iv$iv;
            Iterable $this$associateBy$iv = result2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo22 = $this$associateBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                m = (Pair)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(((ClangTestIndexScopeElement)it.getSecond()).getMyOffset(), element$iv$iv);
            }
            Map allMarkers = destination$iv$iv2;
            Iterable $this$associate$iv = result2;
            boolean $i$f$associate = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv2 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                OCTestFramework it2;
                Map map = destination$iv$iv3;
                it2 = (Pair)element$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)((ClionTestRunLineMarker)it2.getFirst()).getQDeclName(), it2.getSecond());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map cidrTestObjects = destination$iv$iv3;
            CachedIndexedObjects cachedIndexedObjects = new CachedIndexedObjects(version, allMarkers, cidrTestObjects);
            file.putUserData(CACHE_KEY, (Object)cachedIndexedObjects);
            CachedIndexedObjects cachedIndexedObjects2 = cachedIndexedObjects;
            return cachedIndexedObjects2;
        }
    }

    @NotNull
    public Map<String, CidrTestScopeElement> gatherTestLinks(@NotNull PsiFile file, @NotNull String framework) {
        CachedIndexedObjects indexedTests = this.getIndexedData(file, false);
        return indexedTests.getCidrTestObjects();
    }

    private final CidrTestScopeElement extractTest(PsiElement element, CachedIndexedObjects indexedTests) {
        Pair<ClionTestRunLineMarker, CidrTestScopeElement> maybeResult;
        Pair<ClionTestRunLineMarker, CidrTestScopeElement> pair = maybeResult = indexedTests.getAllMarkers().get(element.getTextRange().getStartOffset());
        return pair != null ? (CidrTestScopeElement)pair.getSecond() : null;
    }

    @Nullable
    public CidrTestScopeElement findTest(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        CachedIndexedObjects indexedTests = this.getIndexedData(file, true);
        return this.extractTest(element, indexedTests);
    }

    public boolean canProcessFile(@NotNull PsiFile file, @NotNull String framework) {
        return CidrTestIndexContributor.isOpened((PsiFile)file) && ClangdSettings.getInstance((Project)file.getProject()).isClangdOn() && !ClangLanguageServiceProvider.getIfStarted((Project)file.getProject()).isFileBanned(file.getVirtualFile().getUrl()) && ClangTestIndexContributor.Companion.getEnabledFrameworks().contains(framework);
    }

    static {
        Object[] objectArray = new String[]{"Gtest", "Boost", "Doctest", "Catch"};
        ALL_FRAMEWORK_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J!\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003JK\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u000bH\u00d6\u0001R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$CachedIndexedObjects;", "", "fileVersion", "", "allMarkers", "", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionTestRunLineMarker;", "Lcom/jetbrains/cidr/execution/testing/CidrTestScopeElement;", "cidrTestObjects", "", "(JLjava/util/Map;Ljava/util/Map;)V", "getAllMarkers", "()Ljava/util/Map;", "getCidrTestObjects", "getFileVersion", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.c.clangdBridge"})
    private static final class CachedIndexedObjects {
        private final long fileVersion;
        @NotNull
        private final Map<Integer, Pair<ClionTestRunLineMarker, CidrTestScopeElement>> allMarkers;
        @NotNull
        private final Map<String, CidrTestScopeElement> cidrTestObjects;

        public CachedIndexedObjects(long fileVersion, @NotNull Map<Integer, ? extends Pair<ClionTestRunLineMarker, ? extends CidrTestScopeElement>> allMarkers, @NotNull Map<String, ? extends CidrTestScopeElement> cidrTestObjects) {
            this.fileVersion = fileVersion;
            this.allMarkers = allMarkers;
            this.cidrTestObjects = cidrTestObjects;
        }

        public final long getFileVersion() {
            return this.fileVersion;
        }

        @NotNull
        public final Map<Integer, Pair<ClionTestRunLineMarker, CidrTestScopeElement>> getAllMarkers() {
            return this.allMarkers;
        }

        @NotNull
        public final Map<String, CidrTestScopeElement> getCidrTestObjects() {
            return this.cidrTestObjects;
        }

        public final long component1() {
            return this.fileVersion;
        }

        @NotNull
        public final Map<Integer, Pair<ClionTestRunLineMarker, CidrTestScopeElement>> component2() {
            return this.allMarkers;
        }

        @NotNull
        public final Map<String, CidrTestScopeElement> component3() {
            return this.cidrTestObjects;
        }

        @NotNull
        public final CachedIndexedObjects copy(long fileVersion, @NotNull Map<Integer, ? extends Pair<ClionTestRunLineMarker, ? extends CidrTestScopeElement>> allMarkers, @NotNull Map<String, ? extends CidrTestScopeElement> cidrTestObjects) {
            return new CachedIndexedObjects(fileVersion, allMarkers, cidrTestObjects);
        }

        public static /* synthetic */ CachedIndexedObjects copy$default(CachedIndexedObjects cachedIndexedObjects, long l, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                l = cachedIndexedObjects.fileVersion;
            }
            if ((n & 2) != 0) {
                map = cachedIndexedObjects.allMarkers;
            }
            if ((n & 4) != 0) {
                map2 = cachedIndexedObjects.cidrTestObjects;
            }
            return cachedIndexedObjects.copy(l, map, map2);
        }

        @NotNull
        public String toString() {
            return "CachedIndexedObjects(fileVersion=" + this.fileVersion + ", allMarkers=" + this.allMarkers + ", cidrTestObjects=" + this.cidrTestObjects + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.fileVersion);
            result2 = result2 * 31 + ((Object)this.allMarkers).hashCode();
            result2 = result2 * 31 + ((Object)this.cidrTestObjects).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CachedIndexedObjects)) {
                return false;
            }
            CachedIndexedObjects cachedIndexedObjects = (CachedIndexedObjects)other;
            if (this.fileVersion != cachedIndexedObjects.fileVersion) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allMarkers, cachedIndexedObjects.allMarkers)) {
                return false;
            }
            return Intrinsics.areEqual(this.cidrTestObjects, cachedIndexedObjects.cidrTestObjects);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$Companion;", "", "()V", "ALL_FRAMEWORK_NAMES", "", "", "getALL_FRAMEWORK_NAMES", "()Ljava/util/List;", "CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/testing/ClangTestIndexContributor$CachedIndexedObjects;", "getAllTestLineMarkers", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClionTestRunLineMarker;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "enabledFrameworks", "getEnabledFrameworks", "intellij.c.clangdBridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getALL_FRAMEWORK_NAMES() {
            return ALL_FRAMEWORK_NAMES;
        }

        private final List<String> getEnabledFrameworks() {
            ArrayList<String> enabledFrameworks = new ArrayList<String>();
            for (String pr : this.getALL_FRAMEWORK_NAMES()) {
                String registryKeyStr = "cidr.enable.testRunLineMarkers.clang" + pr + "TestFrameworkSupport";
                boolean enabled = Registry.is((String)registryKeyStr);
                if (!enabled) continue;
                String string = pr.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                enabledFrameworks.add(string);
            }
            return enabledFrameworks;
        }

        @NotNull
        public final List<ClionTestRunLineMarker> getAllTestLineMarkers(@NotNull VirtualFile file, @NotNull Project project, @NotNull List<String> enabledFrameworks) {
            ClangLanguageService service = ClangLanguageServiceProvider.getOrStart((Project)project);
            Ref markers = Ref.create();
            service.runWithOpenedAndParsed(file, arg_0 -> Companion.getAllTestLineMarkers$lambda$2(service, file, enabledFrameworks, markers, arg_0));
            return (List)markers.get();
        }

        public static /* synthetic */ List getAllTestLineMarkers$default(Companion companion, VirtualFile virtualFile, Project project, List list, int n, Object object) {
            if ((n & 4) != 0) {
                list = companion.getEnabledFrameworks();
            }
            return companion.getAllTestLineMarkers(virtualFile, project, list);
        }

        private static final void getAllTestLineMarkers$lambda$2$lambda$1(Ref $markers, ClangResult it) {
            try {
                List list = (List)it.waitForResult();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                $markers.set((Object)list);
            }
            catch (ExecutionException e) {
                CidrLogService.LOG.warn((Throwable)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final void getAllTestLineMarkers$lambda$2(ClangLanguageService $service, VirtualFile $file, List $enabledFrameworks, Ref $markers, ClangParseResponse it) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $enabledFrameworks;
            VirtualFile virtualFile = $file;
            ClangLanguageService clangLanguageService = $service;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            clangLanguageService.getTestLineMarkers(virtualFile, (List)collection, arg_0 -> Companion.getAllTestLineMarkers$lambda$2$lambda$1($markers, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

