/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnusedIncludeDirectiveInspection
extends OCInspection
implements OCInspectionBase.CppMarker {
    private static final Logger LOG = Logger.getInstance((String)OCUnusedIncludeDirectiveInspection.class.getName());
    @NotNull
    public EliminateStrategy strategy = EliminateStrategy.RemoveNotDirectlyUsed;
    public boolean showInHeaders = false;

    public boolean isEnabledByDefault() {
        return PluginUtils.hasCLion();
    }

    public String getMainToolId() {
        return null;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return CidrLangBundle.message((String)"inspection.unused.code", (Object[])new Object[0]);
    }

    public String @NotNull [] getGroupPath() {
        return new String[]{CidrLangBundle.message((String)"c.cpp", (Object[])new Object[0]), this.getGroupDisplayName()};
    }

    @Nullable
    public String getStaticDescription() {
        return OCInspectionUtil.getStaticDescription((OCInspectionBase)this);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        final Class inspectionClass = this.getInspectionClass();
        if (!OCInspectionUtil.isInspectionEnabled((Project)holder.getFile().getProject(), (Class)inspectionClass)) {
            return new PsiElementVisitor(){};
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (isOnTheFly) {
                    return;
                }
                if (!ClangUtils.isClangdOn((Project)file.getProject())) {
                    return;
                }
                if (!ClangdBridge.isSupported((Project)file.getProject(), (VirtualFile)file.getVirtualFile())) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)file.getProject());
                List<ClangDiagnostic> unusedDiagnostics = OCUnusedIncludeDirectiveInspection.getUnusedDiagnostics(service, file);
                if (!unusedDiagnostics.isEmpty()) {
                    Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                    if (document == null) {
                        return;
                    }
                    HighlightInfoHolder highlightInfos = new HighlightInfoHolder(file, new HighlightInfoFilter[0]);
                    for (ClangDiagnostic diag : unusedDiagnostics) {
                        HighlightInfo info = ClangErrorsAnnotatorPass.makeAnnotation((ClangIdeFacade)service.getClangIdeFacade(), (ClangDiagnostic)diag, (PsiFile)file, (Document)document, (HighlightInfoHolder)highlightInfos, (ClangUrlConverter)service.getUrlConverter());
                        ProblemDescriptor descriptor = info == null ? null : ProblemDescriptorUtil.toProblemDescriptor((PsiFile)file, (HighlightInfo)info);
                        if (descriptor == null) continue;
                        OCInspection.registerProblem((ProblemsHolder)holder, null, null, (boolean)isOnTheFly, (PsiElement)descriptor.getStartElement(), (PsiElement)descriptor.getEndElement(), (String)info.getDescription(), (String)"CIDR", (ProblemHighlightType)ProblemHighlightType.LIKE_UNUSED_SYMBOL, (TextRange)new TextRange(info.startOffset, info.endOffset), (Class)inspectionClass, (IntentionAction[])IntentionAction.EMPTY_ARRAY);
                    }
                }
            }
        };
    }

    @NotNull
    private static List<ClangDiagnostic> getUnusedDiagnostics(@NotNull ClangLanguageService service, @NotNull PsiFile file) {
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return (List)service.computeWithOpenedAndParsed(virtualFile, response -> {
            if (response != null) {
                try {
                    Supplier diagsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware((Future)response.getDiagnostics(), (long)Long.MAX_VALUE, (String)"unused include diagnostics");
                    if (diagsSupplier != null) {
                        List diagnostics2 = (List)diagsSupplier.get();
                        return diagnostics2 != null ? ContainerUtil.filter((Collection)diagnostics2, diag -> "clion_unused_include".equals(diag.getCode())) : Collections.emptyList();
                    }
                }
                catch (ExecutionException | TimeoutException e) {
                    LOG.error((Throwable)e);
                }
            }
            return Collections.emptyList();
        });
    }

    public JComponent createOptionsPanel() {
        if (!PluginUtils.hasCLion()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel = new JPanel(new GridBagLayout());
        final ComboBox comboBox = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)ContainerUtil.map((Object[])EliminateStrategy.values(), opt -> opt.option)));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OCUnusedIncludeDirectiveInspection.this.strategy = EliminateStrategy.values()[comboBox.getSelectedIndex()];
            }
        });
        comboBox.setSelectedIndex(EliminateStrategy.indexOf(this.strategy));
        panel.add((Component)comboBox, bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        panel.add((Component)new CheckBox(OCInspectionsBundle.message((String)"unused.inspection.run.in.headers", (Object[])new Object[0]), (InspectionProfileEntry)this, "showInHeaders"), bag.nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        return panel;
    }

    public static enum EliminateStrategy {
        RemoveCompletelyUnused("Detect completely unused"),
        RemoveNotDirectlyUsed("Detect not directly used"),
        RemoveNotRequired("Detect not required");

        @NotNull
        public final String option;

        private EliminateStrategy(String option) {
            this.option = option;
        }

        static int indexOf(@NotNull EliminateStrategy opt) {
            int index = 0;
            for (EliminateStrategy strategy : EliminateStrategy.values()) {
                if (strategy == opt) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }
}

