/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangdQuickFix;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierImpl;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangdErrorsAndWarningsInspection
extends GlobalSimpleInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message((String)"inspection.clangd.general", (Object[])new Object[0]);
    }

    public String @NotNull [] getGroupPath() {
        return new String[]{CidrLangBundle.message((String)"c.cpp", (Object[])new Object[0]), this.getGroupDisplayName()};
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return CidrLangBundle.message((String)"inspection.general", (Object[])new Object[0]);
    }

    public boolean showDefaultConfigurationOptions() {
        return false;
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (!ClangUtils.isClangdOn((Project)file.getProject())) {
            return;
        }
        if (!OCLanguageUtils.isSupported((PsiFile)file)) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getOrStart((Project)file.getProject());
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        try {
            List allDiagnostics = (List)service.computeWithOpenedAndParsed(virtualFile, response -> (List)ClangUtils.waitForClangFuture((Future)response.getDiagnostics()));
            if (allDiagnostics != null) {
                for (ClangDiagnostic diag : allDiagnostics) {
                    ProblemHighlightType highlightType;
                    int offset;
                    PsiElement elementToAnnotate;
                    if (StringUtil.equals((CharSequence)"clion_unused_include", (CharSequence)diag.getCode()) || ClangErrorsAnnotatorPass.isIgnoredDiagnostic((ClangDiagnostic)diag) || (elementToAnnotate = ClangTidyAnnotationApplierImpl.getElementToAnnotate(file, offset = document.getLineStartOffset(diag.getStartLine()) + diag.getStartColumn(), false)) == null && ((elementToAnnotate = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild()) == null || OCElementUtil.isWhitespace((PsiElement)elementToAnnotate) || elementToAnnotate instanceof PsiErrorElement) || (highlightType = ClangErrorsAnnotatorPass.clangdSeverity2ProblemHighlightType((ClangDiagnostic)diag)) != ProblemHighlightType.ERROR && highlightType != ProblemHighlightType.GENERIC_ERROR && highlightType != ProblemHighlightType.GENERIC_ERROR_OR_WARNING && highlightType != ProblemHighlightType.WARNING) continue;
                    OCResolveContext context = OCResolveContext.forPsi((PsiElement)elementToAnnotate);
                    ArrayList<LocalQuickFix> localQuickFixes = new ArrayList<LocalQuickFix>(ContainerUtil.map((Collection)diag.getClangdFixits(), f -> new ClangdQuickFix(f)));
                    for (ClionFixItHint fixit : diag.getClionFixits()) {
                        for (IntentionAction quickFix : ClangQuickFixFactoryKt.getClangQuickFixes(fixit, context, elementToAnnotate, service.getUrlConverter())) {
                            if (!(quickFix instanceof LocalQuickFix)) continue;
                            localQuickFixes.add((LocalQuickFix)quickFix);
                        }
                    }
                    String diagnosticMessage = diag.getMessage();
                    List<String> sufficesToRemove = Arrays.asList(" (fix available)", " (fixes available)");
                    for (String s : sufficesToRemove) {
                        if (!diagnosticMessage.endsWith(s)) continue;
                        diagnosticMessage = diagnosticMessage.substring(0, diagnosticMessage.length() - s.length());
                    }
                    problemsHolder.registerProblem(elementToAnnotate, diagnosticMessage, highlightType, localQuickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }
        catch (Exception e) {
            CidrLogService.LOG.warn(((Object)((Object)this)).getClass().getName() + " in batch mode failed.", (Throwable)e);
        }
    }
}

