/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFAAggregationValue;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDfaResultProvider;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDfaResultProviderImpl;", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDfaResultProvider;", "()V", "POINTS_TO_INFO", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDfaResultProviderImpl$DFAResultInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getModificationStamp", "", "project", "Lcom/intellij/openapi/project/Project;", "loadValues", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDFAAggregationValue;", "range", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "storeValues", "", "values", "", "DFAResultInfo", "intellij.c.clangdBridge"})
public final class OCDfaResultProviderImpl
implements OCDfaResultProvider {
    @NotNull
    private final Key<DFAResultInfo> POINTS_TO_INFO = Key.create((String)"POINTS_TO_INFO");

    @Override
    public void storeValues(@NotNull Map<TextRange, ? extends OCDFAAggregationValue> values, @NotNull PsiFile file) {
        long stamp = this.getModificationStamp(file.getProject());
        file.putUserData(this.POINTS_TO_INFO, (Object)new DFAResultInfo(stamp, values));
    }

    @Override
    @Nullable
    public OCDFAAggregationValue loadValues(@NotNull TextRange range, @NotNull PsiFile file) {
        DFAResultInfo dFAResultInfo = (DFAResultInfo)file.getUserData(this.POINTS_TO_INFO);
        if (dFAResultInfo == null) {
            return null;
        }
        DFAResultInfo resultInfo = dFAResultInfo;
        long currentModificationStamp = this.getModificationStamp(file.getProject());
        if (resultInfo.getStamp() == currentModificationStamp) {
            return resultInfo.getResult().get(range);
        }
        return null;
    }

    private final long getModificationStamp(Project project) {
        ClangLanguageService clangService = ClangLanguageServiceProvider.getIfStarted((Project)project);
        Long l = clangService.getClangIdeFacade().getPsiModificationCounter(project);
        return l != null ? l : 0L;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDfaResultProviderImpl$DFAResultInfo;", "", "stamp", "", "result", "", "Lcom/intellij/openapi/util/TextRange;", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDFAAggregationValue;", "(JLjava/util/Map;)V", "getResult", "()Ljava/util/Map;", "getStamp", "()J", "intellij.c.clangdBridge"})
    private static final class DFAResultInfo {
        private final long stamp;
        @NotNull
        private final Map<TextRange, OCDFAAggregationValue> result;

        public DFAResultInfo(long stamp, @NotNull Map<TextRange, ? extends OCDFAAggregationValue> result2) {
            this.stamp = stamp;
            this.result = result2;
        }

        public final long getStamp() {
            return this.stamp;
        }

        @NotNull
        public final Map<TextRange, OCDFAAggregationValue> getResult() {
            return this.result;
        }
    }
}

